<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body,
    html {
        margin: 0;
        padding: 0;
        height: 100%;
        font-family: "Poppins", sans-serif;
        background-color: #e8f5e9;
    }

    .search-restaurant-wrapper {
        position: fixed;
        top: 0;
        left: 50%;
        transform: translateX(-50%);
        z-index: 100;
        width: 100%;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        padding: 20px 15px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        border-bottom-left-radius: 15px;
        border-bottom-right-radius: 15px;
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .location-wrapper {
        padding-top: 30px;
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 14px;
        color: #fff;
    }

    .location-wrapper i {
        color: #ffeb3b;
    }

    .location-text {
        flex: 1;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .alfafood-container {
        margin: 0 auto;
        width: 100%;
        min-height: calc(100vh - 125px);
        padding-top: 110px;
        background-color: #e8f5e9;
        overflow-y: auto;
    }

    /* ==== Wrapper ==== */
    .order-page {
        width: 95%;
        max-width: 1200px;
        margin: 0 auto;
        /* padding: 60px 0 110px; */
        /* 🔥 lebih kecil */
        min-height: calc(100vh - 100px);
        /* pastikan konten penuh layar */
        display: flex;
        flex-direction: column;
        align-items: stretch;
        justify-content: flex-start;
        /* ✅ dorong card ke atas */
        padding-top: 60px;
        overflow-y: auto;
        /* scroll hanya saat konten lebih tinggi dari layar */

    }

    .alfafood-container::-webkit-scrollbar {
        display: none;
    }

    .search-group {
        display: flex;
        width: 100%;
    }

    .search-group input {
        flex: 1;
        padding: 12px 15px;
        border: 1px solid #e8f5e9;
        border-radius: 10px 0 0 10px;
        outline: none;
        font-size: 14px;
    }

    .search-group .search-btn {
        width: 50px;
        border: 1px solid #e8f5e9;
        border-left: none;
        border-radius: 0 10px 10px 0;
        background: #e8f5e9;
        display: flex;
        justify-content: center;
        align-items: center;
        cursor: pointer;
        color: #27ae60;
        transition: 0.3s;
    }

    /* ====== CARD RESTO ====== */
    .restaurant-card {
        position: relative;
        background: linear-gradient(145deg, #27ae60, #2ecc71);
        color: #fff;
        border-radius: 20px;
        padding: 12px 16px;
        display: flex;
        align-items: center;
        gap: 15px;
        margin: 12px 10px;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        cursor: pointer;
        height: 90px;
        transition: transform 0.25s ease, box-shadow 0.25s ease;
    }

    .restaurant-card:hover {
        transform: scale(1.02);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.25);
    }

    .restaurant-card img {
        width: 60px;
        height: 60px;
        border-radius: 14px;
        object-fit: cover;
    }

    .restaurant-card .info {
        flex: 1;
    }

    .restaurant-card h4 {
        font-weight: 700;
        font-size: 1.1rem;
        margin-bottom: 4px;
    }

    .restaurant-card p {
        font-size: 13px;
        opacity: 0.9;
        margin: 0;
    }

    /* ⭐ Rating Badge (pojok kanan atas) */
    .rating-badge {
        position: absolute;
        top: 8px;
        right: 10px;
        display: inline-flex;
        align-items: center;
        gap: 4px;
        background: rgba(0, 0, 0, 0.35);
        border-radius: 12px;
        padding: 4px 8px;
        font-size: 13px;
        font-weight: 500;
        color: #fff;
        backdrop-filter: blur(4px);
    }

    .rating-badge i {
        color: #ffeb3b;
        font-size: 0.9rem;
    }

    /* Variasi warna card */
    .restaurant-card:nth-child(8n+1) {
        background: linear-gradient(145deg, #27ae60, #2ecc71);
    }

    .restaurant-card:nth-child(8n+2) {
        background: linear-gradient(145deg, #e67e22, #f39c12);
    }

    .restaurant-card:nth-child(8n+3) {
        background: linear-gradient(145deg, #2980b9, #3498db);
    }

    .restaurant-card:nth-child(8n+4) {
        background: linear-gradient(145deg, #8e44ad, #9b59b6);
    }

    .restaurant-card:nth-child(8n+5) {
        background: linear-gradient(145deg, #d35400, #e67e22);
    }

    .restaurant-card:nth-child(8n+6) {
        background: linear-gradient(145deg, #16a085, #1abc9c);
    }

    .restaurant-card:nth-child(8n+7) {
        background: linear-gradient(145deg, #c0392b, #e74c3c);
    }

    .restaurant-card:nth-child(8n+8) {
        background: linear-gradient(145deg, #2c3e50, #34495e);
    }
</style>

<div class="search-restaurant-wrapper">
    <div class="location-wrapper">
        <i class="fa-solid fa-location-dot"></i>
        <span class="location-text" id="current-location">Mencari lokasi...</span>
    </div>
    <div class="search-group">
        <input id="searchBox" type="text" placeholder="Cari restoran...">
        <button class="search-btn">
            <i class="fa-solid fa-magnifying-glass"></i>
        </button>
    </div>
</div>

<div class="alfafood-container">
    <div class="restaurants-list" id="restaurants-list"></div>
</div>


<script src="<?= base_url('js/profile.js') ?>"></script>


<?= $this->endSection() ?>