<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Coming Soon | AlfaGo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            background: linear-gradient(135deg, #0D47A1, #1976D2);
            color: #fff;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
        }

        .coming-soon-box {
            max-width: 500px;
            padding: 40px 30px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 20px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
            backdrop-filter: blur(10px);
        }

        .coming-soon-box img {
            width: 120px;
            margin-bottom: 20px;
        }

        .coming-soon-box h1 {
            font-size: 2.2rem;
            font-weight: bold;
            margin-bottom: 15px;
        }

        .coming-soon-box p {
            font-size: 1rem;
            margin-bottom: 30px;
            opacity: 0.9;
        }

        .spinner-border {
            width: 3rem;
            height: 3rem;
        }

        footer {
            margin-top: 25px;
            font-size: 0.9rem;
            opacity: 0.8;
        }
    </style>
</head>

<body>
    <div class="coming-soon-box">
        <!-- Logo -->
        <img src="<?= base_url('logo.png') ?>" alt="AlfaGo Logo">

        <!-- Title -->
        <h1>🚀 Coming Soon</h1>
        <p>Fitur baru AlfaGo sedang dalam tahap pengembangan.<br>
            Nantikan segera!</p>

        <!-- Loader -->
        <div class="spinner-border text-light" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>

        <!-- Footer -->
        <footer>© <?= date('Y') ?> Alfa Teknologi</footer>
    </div>
</body>

</html>