<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>


<style>
    body {
        background: linear-gradient(135deg, #16a085, #2980b9);
        height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        font-family: 'Segoe UI', sans-serif;
        color: #fff;
    }

    .login-container {
        width: 100%;
        max-width: 400px;
        text-align: center;
        padding: 20px;
    }

    .login-container img {
        width: 220px;
        height: auto;
        padding-bottom: 50px;
    }

    .form-control {
        border-radius: 10px;
        border: none;
        padding: 12px;
    }

    .form-control:focus {
        box-shadow: none !important;
        outline: none !important;
    }

    /* 🔥 Jarak icon WhatsApp ke input lebih dekat */
    .input-group-text {
        padding: 6px 10px !important;
        /* semakin kecil padding, semakin rapat */
    }

    .btn-login {
        border-radius: 10px;
        font-weight: 600;
        padding: 12px;
        background: #2ecc71;
        border: 1px solid #fff;
        color: #fff;
        transition: 0.3s;
    }

    .btn-login:hover {
        background: #2ecc71;
        border: 1px solid #fff;
    }

    .alert {
        border-radius: 10px;
        font-size: 14px;
    }

    footer {
        margin-top: 30px;
        font-size: 14px;
        opacity: 0.8;
    }

    .mobile-only-message {
        display: none;
        text-align: center;
        font-size: 18px;
    }
</style>

</style>

<div class="login-container" id="loginForm">
    <img src="<?= base_url('images/alfago.png'); ?>" alt="AlfaGo Logo">
    <h3 class="mb-4">Login dengan No WhatsApp</h3>

    <?php if (session()->getFlashdata('info')): ?>
        <div class="alert alert-info">
            <?= session()->getFlashdata('info'); ?>
        </div>
    <?php endif; ?>

    <!-- 🔥 Tambahan Flash Message (Tanpa Merubah Kode Lain) -->
    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger">
            <?= session()->getFlashdata('error'); ?>
        </div>
    <?php endif; ?>

    <form action="<?= base_url('login'); ?>" method="post" id="formLogin">
        <?= csrf_field(); ?>
        <div class="mb-3 input-group">
            <span class="input-group-text bg-white border-0 rounded-start">
                <i class="fa-brands fa-whatsapp text-success"></i>
            </span>
            <input type="tel" name="phone" class="form-control" placeholder="08xxxxxxxx" pattern="[0-9]+"
                inputmode="numeric" maxlength="15">
        </div>

        <button type="submit" class="btn btn-login w-100">
            <i class="fa-solid fa-right-to-bracket"></i> Login
        </button>
    </form>

    <footer>© <?= date('Y'); ?> AlfaGo</footer>
</div>

<div class="mobile-only-message" id="desktopMessage">
    📱 Silakan buka halaman ini di perangkat mobile
</div>

<script src="<?= base_url('js/login.js') ?>"></script>

<?= $this->endSection() ?>