<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body {
        font-family: "Poppins", sans-serif;
        background: linear-gradient(135deg, #16a085, #2980b9);
        margin: 0;
        padding: 0;
        color: #333;
        min-height: 100vh;
        overflow-x: hidden;
    }

    .menu-wrapper {
        width: 95%;
        max-width: 1200px;
        margin: 0 auto;
        min-height: calc(100vh - 100px);
        display: flex;
        flex-direction: column;
        justify-content: flex-start;
        overflow-y: auto;
        padding-top: 90px;
        /* kompensasi header fixed */
        padding-bottom: 60px;
    }

    /* === HEADER FIXED === */
    .header-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: linear-gradient(135deg, #16a085, #2980b9);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
        z-index: 999;
    }

    .menu-header-content {
        width: 90%;
        max-width: 1200px;
        margin: 0 auto;
        padding: 10px 0 12px 0;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    /* === BACK ICON DALAM HEADER === */
    .back-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 255, 255, 0.15);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: background 0.2s;
        text-decoration: none;
        /* ✅ Hapus garis bawah */
    }

    .back-icon:hover {
        background: rgba(255, 255, 255, 0.3);
        text-decoration: none;
        /* ✅ Pastikan tetap tanpa underline saat hover */
    }

    .menu-header {
        flex: 1;
        text-align: center;
        color: #fff;
    }

    .menu-header h2 {
        margin: 0;
        font-size: 1.5rem;
        font-weight: 700;
    }

    .menu-header small {
        opacity: 0.9;
        font-size: 0.9rem;
        font-weight: 400;
    }

    /* === MENU LIST === */
    .menu-list {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .menu-card {
        background: #fff;
        border-radius: 12px;
        padding: 12px 14px;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.08);
        display: flex;
        flex-direction: column;
    }

    .menu-top {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .menu-left {
        display: flex;
        align-items: center;
        gap: 10px;
        flex: 1;
        overflow: hidden;
    }

    .menu-img-wrapper {
        width: 56px;
        height: 56px;
        border-radius: 10px;
        overflow: hidden;
        background: #f3f4f6;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .menu-img-wrapper img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .icon-fallback {
        font-size: 30px;
        color: #16a085;
    }

    .menu-info {
        overflow: hidden;
    }

    .menu-info h4 {
        margin: 0;
        font-size: 1.05rem;
        font-weight: 600;
        color: #2c3e50;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .menu-info p {
        margin: 2px 0;
        font-size: 0.85rem;
        color: #777;
    }

    .menu-price {
        font-weight: 700;
        color: #27ae60;
        font-size: 0.9rem;
    }

    /* === NOTE + ADD === */
    .menu-actions-right {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .note-icon {
        color: #16a085;
        cursor: pointer;
        font-size: 1rem;
        opacity: 0;
        transition: opacity 0.3s ease, color 0.2s ease;
    }

    .note-icon.visible {
        opacity: 1;
    }

    .note-icon:hover {
        color: #138d75;
    }


    .note-icon.visible {
        opacity: 1;
    }

    .menu-add-btn {
        background: #16a085;
        color: #fff;
        border: none;
        border-radius: 20px;
        padding: 5px 14px;
        font-weight: 600;
        cursor: pointer;
        font-size: 0.85rem;
        height: 28px;
    }

    .menu-action {
        display: none;
        align-items: center;
        background: #f1f1f1;
        border-radius: 20px;
        overflow: hidden;
        height: 28px;
    }

    .menu-action button {
        background: #16a085;
        color: #fff;
        border: none;
        width: 28px;
        height: 28px;
        font-size: 16px;
        cursor: pointer;
    }

    .menu-qty {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 32px;
        height: 28px;
        background: #fff;
        font-weight: 600;
        color: #333;
        border-left: 1px solid #ddd;
        border-right: 1px solid #ddd;
        font-size: 0.9rem;
    }

    .menu-note {
        display: none;
        margin-top: 8px;
        width: 100%;
        animation: fadeInNote 0.25s ease;
    }

    .note-input {
        width: 100%;
        border: 1px solid #ddd;
        border-radius: 8px;
        padding: 6px 8px;
        font-size: 0.9rem;
        color: #333;
        background: #fafafa;
        resize: none;
        overflow: hidden;
        line-height: 1.4;
        min-height: 28px;
        max-height: 120px;
        transition: all 0.15s ease;
    }

    .cart-overlay {
        position: fixed;
        bottom: 0;
        left: 0;
        width: 100%;
        background: #16a085;
        color: #fff;
        text-align: center;
        padding: 14px 0;
        font-size: 1.05rem;
        font-weight: 600;
        display: none;
        cursor: pointer;
        box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.25);
        z-index: 999;
    }




    /* 🌟 Floating Compact Overlay - AlfaGo Theme */
    .floating-cart-overlay {
        position: fixed;
        bottom: 10px;
        /* di atas navbar */
        left: 50%;
        transform: translateX(-50%) translateY(30px);
        background: linear-gradient(135deg, rgba(22, 160, 133, 0.95), rgba(41, 128, 185, 0.95));
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        border-radius: 18px;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.25);
        color: #fff;
        min-width: 260px;
        max-width: 92%;
        cursor: pointer;
        opacity: 0;
        transition: all 0.35s ease;
        z-index: 9999;
    }

    /* Saat muncul */
    .floating-cart-overlay.show {
        opacity: 1;
        transform: translateX(-50%) translateY(0);
    }

    /* === Isi dalam overlay === */
    .floating-cart-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 12px 16px;
    }

    /* === Kiri: ikon & info resto === */
    .cart-info {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    /* Ikon proporsional */
    .cart-icon {
        width: 38px;
        height: 38px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        box-shadow: inset 0 0 6px rgba(255, 255, 255, 0.15);
    }

    .cart-icon i {
        font-size: 1.2rem;
        color: #fff;
        transform: translateY(1px);
    }

    /* Info resto */
    .cart-text {
        display: flex;
        flex-direction: column;
        line-height: 1.2;
    }

    .cart-text strong {
        font-size: 0.95rem;
        color: #fff;
        font-weight: 600;
    }

    .cart-text small {
        font-size: 0.8rem;
        opacity: 0.9;
    }

    /* Panah kanan */
    .cart-arrow i {
        font-size: 1rem;
        color: #fff;
        opacity: 0.85;
    }

    /* Hover efek */
    .floating-cart-overlay:hover {
        transform: translateX(-50%) scale(1.03);
        background: linear-gradient(135deg, rgba(24, 175, 150, 1), rgba(52, 152, 219, 1));
        transition: all 0.25s ease;
    }

    @keyframes fadeInNote {
        from {
            opacity: 0;
            transform: translateY(-5px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>

<div class="menu-wrapper"
    data-restaurant-id="<?= (int)$restaurant['id'] ?>"
    data-restaurant-name="<?= esc($restaurant['name']) ?>">

    <div class="header-wrapper">
        <div class="menu-header-content">
            <a href="<?= base_url('alfafood') ?>" class="back-icon">
                <i class="fa-solid fa-arrow-left"></i>
            </a>
            <div class="menu-header">
                <h2><?= esc($restaurant['name']) ?></h2>
                <small><?= esc($restaurant['description']) ?></small>
            </div>
            <div style="width:36px;"></div> <!-- spacer agar header tetap center -->
        </div>
    </div>

    <div class="menu-list">
        <?php if (empty($menus)): ?>
            <p class="empty">Belum ada menu tersedia 🍽️</p>
        <?php else: ?>
            <?php foreach ($menus as $menu): ?>
                <div class="menu-card"
                    data-id="<?= esc($menu['id']) ?>"
                    data-name="<?= esc($menu['name']) ?>"
                    data-price="<?= esc($menu['price']) ?>">

                    <div class="menu-top">
                        <div class="menu-left">
                            <div class="menu-img-wrapper">
                                <?php if (!empty($menu['image_url'])): ?>
                                    <img src="<?= esc($menu['image_url']) ?>" alt="<?= esc($menu['name']) ?>">
                                <?php else: ?>
                                    <div class="icon-fallback"><i class="fa-solid fa-utensils"></i></div>
                                <?php endif; ?>
                            </div>
                            <div class="menu-info">
                                <h4><?= esc($menu['name']) ?></h4>
                                <p><?= esc($menu['description'] ?? '-') ?></p>
                                <div class="menu-price">Rp <?= number_format($menu['price'], 0, ',', '.') ?></div>
                            </div>
                        </div>

                        <!-- <div class="menu-actions-right">
                            <i class="fa-solid fa-pen note-icon"></i>
                            <button class="menu-add-btn">Tambah</button>
                            <div class="menu-action">
                                <button class="btn-minus">−</button>
                                <div class="menu-qty">1</div>
                                <button class="btn-plus">+</button>
                            </div>
                        </div> -->

                        <div class="menu-actions-right">

                            <i class="fa-solid fa-pen note-icon"></i>

                            <?php if ($menu['available'] == 0): ?>
                                <!-- JIKA HABIS -->
                                <button class="menu-add-btn disabled" disabled style="background:#999; cursor:not-allowed;">
                                    Habis
                                </button>
                            <?php else: ?>
                                <!-- JIKA TERSEDIA -->
                                <button class="menu-add-btn">
                                    Tambah
                                </button>
                            <?php endif; ?>

                            <div class="menu-action" style="display:none;">
                                <button class="btn-minus">−</button>
                                <div class="menu-qty">1</div>
                                <button class="btn-plus">+</button>
                            </div>

                        </div>
                    </div>

                    <div class="menu-note">
                        <textarea class="note-input" rows="1" placeholder="Tulis catatan (opsional)..."></textarea>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<div class="cart-overlay" id="cartOverlay">Lihat Pesanan (0 item)</div>

<script src="<?= base_url('js/alfafood/menu_list.js') ?>"></script>
<?= $this->endSection() ?>