<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body,
    html {
        margin: 0;
        padding: 0;
        height: 100%;
        font-family: "Poppins", sans-serif;
        background-color: #e8f5e9;
    }

    .search-restaurant-wrapper {
        position: fixed;
        top: 0;
        left: 50%;
        transform: translateX(-50%);
        z-index: 100;
        width: 100%;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        padding: 20px 15px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        border-bottom-left-radius: 15px;
        border-bottom-right-radius: 15px;
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .location-wrapper {
        padding-top: 30px;
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 14px;
        color: #fff;
    }

    .location-wrapper i {
        color: #ffeb3b;
    }

    .location-text {
        flex: 1;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .alfafood-container {
        margin: 0 auto;
        width: 100%;
        min-height: calc(100vh - 125px);
        padding-top: 125px;
        background-color: #e8f5e9;
        overflow-y: auto;
    }

    .alfafood-container::-webkit-scrollbar {
        display: none;
    }

    .search-group {
        display: flex;
        width: 100%;
    }

    .search-group input {
        flex: 1;
        padding: 12px 15px;
        border: 1px solid #e8f5e9;
        border-radius: 10px 0 0 10px;
        outline: none;
        font-size: 14px;
    }

    .search-group .search-btn {
        width: 50px;
        border: 1px solid #e8f5e9;
        border-left: none;
        border-radius: 0 10px 10px 0;
        background: #e8f5e9;
        display: flex;
        justify-content: center;
        align-items: center;
        cursor: pointer;
        color: #27ae60;
        transition: 0.3s;
    }

    /* ====== CARD RESTO ====== */
    .restaurant-card {
        position: relative;
        background: linear-gradient(145deg, #27ae60, #2ecc71);
        color: #fff;
        border-radius: 20px;
        padding: 12px 16px;
        display: flex;
        align-items: center;
        gap: 15px;
        margin: 12px 10px;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        cursor: pointer;
        height: 90px;
        transition: transform 0.25s ease, box-shadow 0.25s ease;
    }

    .restaurant-card:hover {
        transform: scale(1.02);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.25);
    }

    .restaurant-card img {
        width: 60px;
        height: 60px;
        border-radius: 14px;
        object-fit: cover;
    }

    .restaurant-card .info {
        flex: 1;
    }

    /* Nama restoran – rapat ke rating */
    .restaurant-card h4 {
        font-weight: 700;
        font-size: 1.05rem;
        margin-bottom: 2px;
        /* 🔥 dari 4px → 2px */
        line-height: 1.2;
    }

    .restaurant-card p {
        font-size: 13px;
        opacity: 0.9;
        margin: 0;
    }


    /* Variasi warna card */
    .restaurant-card:nth-child(8n+1) {
        background: linear-gradient(145deg, #27ae60, #2ecc71);
    }

    .restaurant-card:nth-child(8n+2) {
        background: linear-gradient(145deg, #e67e22, #f39c12);
    }

    .restaurant-card:nth-child(8n+3) {
        background: linear-gradient(145deg, #2980b9, #3498db);
    }

    .restaurant-card:nth-child(8n+4) {
        background: linear-gradient(145deg, #8e44ad, #9b59b6);
    }

    .restaurant-card:nth-child(8n+5) {
        background: linear-gradient(145deg, #d35400, #e67e22);
    }

    .restaurant-card:nth-child(8n+6) {
        background: linear-gradient(145deg, #16a085, #1abc9c);
    }

    .restaurant-card:nth-child(8n+7) {
        background: linear-gradient(145deg, #c0392b, #e74c3c);
    }

    .restaurant-card:nth-child(8n+8) {
        background: linear-gradient(145deg, #2c3e50, #34495e);
    }

    .restaurant-card {
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
        border-radius: 20px;
    }

    /* Efek resto tutup */
    .restaurant-card.closed {
        filter: grayscale(100%) brightness(0.85);
        opacity: 0.85;
        pointer-events: none;
    }

    /* Label kecil di kanan bawah */
    .closed-label {
        position: absolute;
        right: 10px;
        bottom: 8px;
        background: rgba(50, 50, 50, 0.7);
        color: #fff;
        padding: 4px 10px;
        font-size: 0.8rem;
        border-radius: 10px;
        display: flex;
        align-items: center;
        gap: 6px;
        font-weight: 600;
        letter-spacing: 0.4px;
        backdrop-filter: blur(2px);
    }

    .closed-label i {
        font-size: 0.85rem;
        color: #ffeb3b;
        /* emas lembut */
    }

    /* Transisi halus */
    .restaurant-card {
        transition: all 0.25s ease-in-out;
    }





    /* 🌟 Floating Compact Overlay - AlfaGo Theme */
    .floating-cart-overlay {
        position: fixed;
        bottom: 10px;
        /* di atas navbar */
        left: 50%;
        transform: translateX(-50%) translateY(30px);
        background: linear-gradient(135deg, rgba(22, 160, 133, 0.95), rgba(41, 128, 185, 0.95));
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        border-radius: 18px;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.25);
        color: #fff;
        min-width: 260px;
        max-width: 92%;
        cursor: pointer;
        opacity: 0;
        transition: all 0.35s ease;
        z-index: 9999;
    }

    /* Saat muncul */
    .floating-cart-overlay.show {
        opacity: 1;
        transform: translateX(-50%) translateY(0);
    }

    /* === Isi dalam overlay === */
    .floating-cart-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 12px 16px;
    }

    /* === Kiri: ikon & info resto === */
    .cart-info {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    /* Ikon proporsional */
    .cart-icon {
        width: 38px;
        height: 38px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        box-shadow: inset 0 0 6px rgba(255, 255, 255, 0.15);
    }

    .cart-icon i {
        font-size: 1.2rem;
        color: #fff;
        transform: translateY(1px);
    }

    /* Info resto */
    .cart-text {
        display: flex;
        flex-direction: column;
        line-height: 1.2;
    }

    .cart-text strong {
        font-size: 0.95rem;
        color: #fff;
        font-weight: 600;
    }

    .cart-text small {
        font-size: 0.8rem;
        opacity: 0.9;
    }

    /* Panah kanan */
    .cart-arrow i {
        font-size: 1rem;
        color: #fff;
        opacity: 0.85;
    }

    /* Hover efek */
    .floating-cart-overlay:hover {
        transform: translateX(-50%) scale(1.03);
        background: linear-gradient(135deg, rgba(24, 175, 150, 1), rgba(52, 152, 219, 1));
        transition: all 0.25s ease;
    }

    .resto-media {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        /* 🔥 INI YANG KURANG */
        width: 60px;
        height: 100%;
    }


    .resto-media img {
        width: 55px;
        height: 55px;
        border-radius: 8px;
        object-fit: cover;
    }

    /* Rating + jarak – naikkan mendekati nama */
    .rating-under {
        margin-top: 0px;
        /* 🔥 sebelumnya 4px */
        margin-bottom: 4px;
        /* jarak ke deskripsi */
        background: rgba(0, 0, 0, 0.25);
        padding: 3px 6px;
        border-radius: 8px;
        font-size: 11px;
        color: #fff;

        display: inline-flex;
        align-items: center;
        gap: 6px;
        line-height: 1;
        white-space: nowrap;
    }


    .rating-under i {
        color: #ffeb3b;
        font-size: 0.8rem;
        line-height: 1;
    }


    /* Bungkus gambar + rating */
    .resto-image-wrapper {
        position: relative;
        width: 90px;
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    /* Gambar restoran */
    .resto-image {
        width: 44px;
        /* 🔥 lebih kecil & proporsional */
        height: 44px;
        border-radius: 12px;
        object-fit: cover;
        background: rgba(255, 255, 255, 0.15);

        /* optional biar ikon tidak terlalu mencolok */
        padding: 6px;
    }


    /* Rating menyatu di bawah gambar */
    .resto-rating {
        margin-top: 6px;
        background: rgba(0, 0, 0, 0.35);
        padding: 4px 8px;
        border-radius: 10px;
        font-size: 12px;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 4px;
        backdrop-filter: blur(3px);
        color: #fff;
    }

    /* Warna bintang */
    .resto-rating i {
        color: #ffeb3b;
        font-size: 0.9rem;
    }

    .distance-text {
        font-size: 0.7rem;
        color: #e0e0e0;
    }
</style>

<div class="search-restaurant-wrapper">
    <div class="location-wrapper">
        <i class="fa-solid fa-location-dot"></i>
        <span class="location-text" id="current-location">Mencari lokasi...</span>
    </div>
    <div class="search-group">
        <input id="searchBox" type="text" placeholder="Cari restoran...">
        <button class="search-btn">
            <i class="fa-solid fa-magnifying-glass"></i>
        </button>
    </div>
</div>

<div class="alfafood-container">
    <div class="restaurants-list" id="restaurants-list"></div>
</div>

<!-- TEMPLATE: Kartu Restoran -->
<template id="template-restaurant-card">
    <div class="restaurant-card">
        <div class="resto-media">
            <img class="resto-image" src="" alt="">
        </div>

        <div class="info">
            <h4 class="resto-name"></h4>
            <div class="rating-under d-none">
                <div class="rating-line">
                    <i class="fa-solid fa-star"></i>
                    <span class="rating-value"></span>
                </div>
                <div class="distance-line">
                    <i class="fa-solid fa-location-dot"></i>
                    <span class="distance-text"></span>
                </div>
            </div>
            <p class="resto-desc"></p>
        </div>

        <div class="closed-label d-none">
            <i class="fa-solid fa-lock"></i> Tutup
        </div>
    </div>
</template>


<!-- TEMPLATE: No Data -->
<template id="template-no-data">
    <p class="no-data-text" style="text-align:center;color:#666;margin-top:40px;">
        🍽️ Tidak ada restoran ditemukan
    </p>
</template>


<!-- TEMPLATE: Floating Cart -->
<template id="template-cart-overlay">
    <div class="floating-cart-overlay" id="activeCartOverlay">
        <div class="floating-cart-content">
            <div class="cart-info">
                <div class="cart-icon"><i class="fa-solid fa-utensils"></i></div>
                <div class="cart-text">
                    <strong class="cart-resto-name"></strong>
                    <small class="cart-info-small"></small>
                </div>
            </div>
            <div class="cart-arrow">
                <i class="fa-solid fa-chevron-right"></i>
            </div>
        </div>
    </div>
</template>


<script src="<?= base_url('js/alfafood/list.js') ?>"></script>



<?= $this->endSection() ?>