<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body {
        font-family: "Poppins", sans-serif;
        background: linear-gradient(135deg, #16a085, #2980b9);
        margin: 0;
        padding: 0;
        color: #333;
        min-height: 100vh;
        overflow-x: hidden;
    }

    .checkout-wrapper {
        width: 95%;
        max-width: 1200px;
        margin: 0 auto;
        padding-bottom: 80px;
        display: flex;
        flex-direction: column;
        padding-top: 90px;
        /* kompensasi header fixed */
    }

    /* === HEADER FIXED FULL WIDTH === */
    .header-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: linear-gradient(135deg, #16a085, #2980b9);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
        z-index: 999;
    }

    .checkout-header-content {
        width: 90%;
        max-width: 1200px;
        margin: 0 auto;
        padding: 10px 0 14px 0;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    /* === BACK ICON === */
    .back-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 255, 255, 0.15);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        /* ✅ tanpa garis bawah */
        transition: background 0.2s, transform 0.1s;
    }

    .back-icon:hover {
        background: rgba(255, 255, 255, 0.3);
    }

    .back-icon:active {
        transform: scale(0.9);
    }

    /* === HEADER TENGAH === */
    .checkout-header {
        flex: 1;
        text-align: center;
        color: #fff;
    }

    .checkout-header h2 {
        margin: 0;
        font-size: 1.5rem;
        font-weight: 700;
    }

    .checkout-header small {
        opacity: 0.9;
        font-size: 0.9rem;
        font-weight: 400;
    }

    /* === KONTEN CHECKOUT === */
    .checkout-section {
        background: #fff;
        border-radius: 12px;
        padding: 14px 16px;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.08);
        margin-bottom: 14px;
    }

    .checkout-section h4 {
        margin: 0 0 10px 0;
        font-weight: 600;
        font-size: 1.05rem;
        color: #2c3e50;
    }

    .checkout-section input,
    .checkout-section select {
        width: 100%;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 8px;
        font-size: 0.9rem;
        outline: none;
    }

    .checkout-section input:focus,
    .checkout-section select:focus {
        border-color: #16a085;
        box-shadow: 0 0 4px rgba(22, 160, 133, 0.3);
    }

    .order-list {
        display: flex;
        flex-direction: column;
        gap: 6px;
    }

    .order-item {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        padding: 6px 0;
        border-bottom: 1px solid #eee;
        font-size: 0.9rem;
    }

    .order-item:last-child {
        border-bottom: none;
    }

    .order-note {
        font-size: 0.85rem;
        color: #555;
        margin-top: 4px;
        font-style: italic;
    }

    .order-note strong {
        display: block;
        color: #16a085;
        margin-bottom: 2px;
    }

    .order-note-text {
        white-space: pre-wrap;
        word-break: break-word;
    }

    .cost-line {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 4px 0;
        font-size: 0.9rem;
        border-bottom: 1px dashed #eee;
        color: #333;
    }

    .total-line {
        border-top: 1px dashed #ccc;
        margin-top: 8px;
        padding-top: 6px;
        text-align: right;
        font-weight: 700;
        color: #27ae60;
        font-size: 1rem;
    }

    .btn-pesan {
        width: 100%;
        background: #16a085;
        color: #fff;
        border: none;
        border-radius: 10px;
        padding: 12px;
        font-weight: 600;
        cursor: pointer;
        font-size: 1rem;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.15);

        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }

    .btn-pesan:hover {
        background: #138d75;
    }

    /* Spinner kecil di tombol */
    .btn-spinner {
        width: 18px;
        height: 18px;
        border: 3px solid rgba(255, 255, 255, 0.4);
        border-top-color: #fff;
        border-radius: 50%;
        animation: spin 0.8s linear infinite;
    }

    .btn-spinner.hidden {
        display: none;
    }

    @keyframes spin {
        to {
            transform: rotate(360deg);
        }
    }

    /* Tombol terkunci */
    .btn-pesan.disabled {
        /* background: #9e9e9e; */
        cursor: not-allowed;
        box-shadow: none;
    }

    .empty {
        text-align: center;
        color: #fff;
        margin-top: 40px;
        font-size: 1rem;
        opacity: 0.9;
    }



    .payment-method {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .pm-option {
        display: flex;
        cursor: pointer;
    }

    .pm-option input {
        display: none;
    }

    .pm-box {
        width: 100%;
        background: #fafafa;
        border-radius: 12px;
        padding: 12px 14px;
        border: 2px solid #ddd;
        display: flex;
        justify-content: space-between;
        align-items: center;
        transition: 0.25s;
    }

    .pm-left {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .pm-title {
        font-weight: 600;
        font-size: 1rem;
    }

    .pm-icon {
        color: #16a085;
        font-size: 1.3rem;
    }

    .pm-right {
        font-weight: 700;
        font-size: 0.95rem;
        color: #16a085;
    }

    /* Saat dipilih */
    .pm-option input:checked+.pm-box {
        border-color: #16a085;
        background: rgba(22, 160, 133, 0.08);
    }

    /* Disable Saldo jika saldo tidak mencukupi */
    .pm-option.disabled .pm-box {
        background: #e4e4e4 !important;
        border-color: #ccc !important;
        color: #777 !important;
        opacity: 0.6;
        cursor: not-allowed;
    }

    .pm-option.disabled .pm-title,
    .pm-option.disabled .pm-right,
    .pm-option.disabled .pm-icon {
        color: #777 !important;
    }

    .pm-option.disabled input {
        pointer-events: none;
    }


    .location-btn-group {
        display: flex;
        gap: 8px;
        margin-top: 10px;
    }

    .loc-btn {
        flex: 1;
        padding: 10px 12px;
        background: #f1f1f1;
        border: 1px solid #ccc;
        border-radius: 8px;
        font-size: 0.9rem;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        transition: 0.2s;
    }

    .loc-btn i {
        color: #16a085;
    }

    .loc-btn:hover {
        background: #e8e8e8;
        border-color: #16a085;
    }

    .mapSelectContainer {
        width: 100%;
        height: 0;
        overflow: hidden;
        border-radius: 12px;
        position: relative;
        transition: height 0.3s ease;
    }

    /* Saat map dibuka, border muncul & map ikut ukurannya */
    .map-border.show .mapSelectContainer {
        height: 300px;
        /* tinggi map disini */
    }

    #selectMap {
        width: 100%;
        height: 100%;
        /* mengikuti mapSelectContainer */
    }



    /* wrapper absolute di dalam container */
    .marker-wrapper {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        pointer-events: none;
    }

    /* marker fixed diletakkan di marker-wrapper */
    .fixed-center-marker {
        position: absolute;
        top: 50%;
        left: 50%;
        width: 40px;
        height: 40px;
        transform: translate(-50%, -100%);
        pointer-events: none;
        z-index: 99;
    }

    .map-border {
        border: none;
        border-radius: 12px;
        padding: 0;
        margin-top: 0;
        transition: 0.25s ease;
    }

    .map-border.show {
        border: 2px solid #16a085;
        margin-top: 12px;
        /* ✔ jarak muncul hanya saat map dibuka */
    }
</style>

<div class="header-wrapper">
    <div class="checkout-header-content">
        <a href="javascript:void(0)" id="backToMenu" class="back-icon">
            <i class="fa-solid fa-arrow-left"></i>
        </a>

        <div class="checkout-header">
            <h2>Detail Pesanan</h2>
            <small id="restaurantName">Memuat...</small>
        </div>

        <div style="width:36px;"></div> <!-- spacer agar judul tetap center -->
    </div>
</div>

<div class="checkout-wrapper">
    <div class="checkout-section">
        <h4>📍 Tujuan Pengantaran</h4>
        <input type="text" id="deliveryAddress" placeholder="Masukkan alamat pengantaran Anda">

        <!-- Tombol Lokasi -->
        <div id="btnLocation" class="location-btn-group">
            <button type="button" class="loc-btn" id="btnMyLocation">
                <i class="fa-solid fa-location-crosshairs"></i> Lokasi Saya
            </button>

            <button type="button" class="loc-btn" id="btnPickFromMap">
                <i class="fa-solid fa-map"></i> Pilih dari maps
            </button>
        </div>

        <!-- MAP CONTAINER -->
        <div id="mapBorder" class="map-border">
            <div id="mapSelectContainer" class="mapSelectContainer">
                <div class="marker-wrapper"></div>
                <div id="selectMap"></div>
            </div>
        </div>



    </div>


    <div class="checkout-section">
        <h4>🍽️ Daftar Pesanan</h4>
        <div id="orderItems" class="order-list"></div>
        <div class="total-line" id="orderSubtotal"></div>
    </div>

    <div class="checkout-section">
        <h4>🚚 Biaya Pengiriman</h4>
        <div class="cost-line">
            <span>Ongkos Kirim</span>
            <span>Rp <span id="shippingCost">0</span></span>
        </div>
        <div class="cost-line">
            <span>Biaya Aplikasi</span>
            <span>Rp <span id="appFee">1.000</span></span>
        </div>
        <div class="total-line" id="orderOngkirTotal">Total: Rp 0</div>
    </div>

    <div class="checkout-section">
        <h4>💳 Metode Pembayaran</h4>

        <div class="payment-method">

            <!-- Tunai -->
            <label class="pm-option">
                <input type="radio" name="payment" value="Tunai" checked>
                <div class="pm-box">
                    <div class="pm-left">
                        <i class="fa-solid fa-money-bill-wave pm-icon"></i>
                        <span class="pm-title">Tunai</span>
                    </div>
                </div>
            </label>

            <!-- Saldo -->
            <label class="pm-option" id="saldoOption">
                <input type="radio" name="payment" value="Saldo" id="paymentSaldo">
                <div class="pm-box">
                    <div class="pm-left">
                        <i class="fa-solid fa-wallet pm-icon"></i>
                        <span class="pm-title">Saldo</span>
                    </div>

                    <!-- SALDO DI KANAN -->
                    <span class="pm-right" id="saldoInfo">Rp 0</span>
                </div>
            </label>

        </div>
    </div>


    <div class="checkout-section">
        <h4>Total Pembayaran</h4>
        <div class="total-line" id="orderGrandTotal">Rp 0</div>
    </div>

    <button class="btn-pesan" id="btnPesan">
        <span class="btn-text">Pesan Sekarang</span>
        <span class="btn-spinner hidden"></span>
    </button>
    <p class="empty" id="emptyNotice" style="display:none;">Keranjang Anda kosong 🍽️</p>
</div>

<script>
    document.addEventListener("DOMContentLoaded", () => {
        const cartData = JSON.parse(localStorage.getItem("cartData") || "{}");
        const orderItemsEl = document.getElementById("orderItems");
        const subtotalEl = document.getElementById("orderSubtotal");
        const subtotalElOngkir = document.getElementById("orderOngkirTotal");
        const totalEl = document.getElementById("orderGrandTotal");
        const restNameEl = document.getElementById("restaurantName");
        const emptyNotice = document.getElementById("emptyNotice");
        const backBtn = document.getElementById("backToMenu");
        const deliveryAddress = document.getElementById("deliveryAddress")
        let lat = null;
        let lng = null;
        let shipping = 0;
        let distance = null;
        let duration = null;
        let tarif = 0;
        let autocomplete;
        let secondAddressDestination = null;

        loadGoogleMaps();
        waitUntilMapReady(() => getNamaTempat());

        async function getNamaTempat0() {
            const getLocation = await getCurrentLocationFetchOnly();
            const status = getLocation.status;
            let grandTotal = 0;

            lat = Latitude;
            lng = Longitude;

            const dstLatLng = new google.maps.LatLng(lat, lng);
            const pickupLatLng = new google.maps.LatLng(window.restaurantLat, window.restaurantLng);
            // =====================================================
            // 🚀 GOOGLE MAPS AUTOCOMPLETE — OPTIMIZED
            // =====================================================
            const options = {
                types: ["geocode"],
                componentRestrictions: {
                    country: "id"
                }
            };

            autocomplete = new google.maps.places.Autocomplete(deliveryAddress, options);
            autocomplete.setFields(["formatted_address", "geometry"]);

            // 🔒 Batasi rekomendasi pencarian radius 5KM
            const circle = new google.maps.Circle({
                center: dstLatLng,
                radius: 5000, // 5 km
            });
            autocomplete.setBounds(circle.getBounds());

            // =====================================================
            // 📍 Saat user memilih lokasi baru
            // =====================================================
            autocomplete.addListener("place_changed", function() {
                const place = autocomplete.getPlace();

                if (!place.geometry) {
                    console.warn("Lokasi tidak valid!");
                    return;
                }

                // Update lat-lng baru berdasarkan pilihan user
                lat = place.geometry.location.lat();
                lng = place.geometry.location.lng();

                // Update input address
                deliveryAddress.value = place.formatted_address;

                // Hitung ulang ongkos kirim + total
                const tujuanBaru = new google.maps.LatLng(lat, lng);
                calcRoute(dstLatLng, tujuanBaru);
            });


            // alert(pickupLatLng);
            // alert(`pickupLatLng: ${pickupLatLng}, dstLatLng: ${dstLatLng}`);



            if (status === "OK" && getLocation.results.length > 0) {
                const fullAddress = getLocation.results[0].formatted_address;
                // alert(fullAddress);

                // Ambil bagian pertama sebelum koma
                const shortAddress = fullAddress.split(",")[0];
                if (deliveryAddress) deliveryAddress.value = shortAddress;
            } else {
                // if (locationText)
                //     locationText.textContent = `Lat: ${Latitude}, Lon: ${Longitude}`;

                if (deliveryAddress) deliveryAddress.value = deliveryAddress.value;
            }

            calcRoute(pickupLatLng, dstLatLng)
                .then(({
                    durationText,
                    distanceM,
                    distanceKm
                }) => {
                    console.log("🕐 ETA:", durationText);
                    console.log("📏 Jarak (m):", distanceM);
                    console.log("📏 Jarak (km):", distanceKm);




                    shipping = hitungOngkos(distanceKm, 'food');

                    console.log(`Shipping: ${shipping}`)


                    const appFee = 1000;
                    const subTotalOngkir = shipping + appFee;
                    const grandTotal = subtotal + shipping + appFee;

                    subtotalEl.textContent = `Subtotal: Rp ${subtotal.toLocaleString()}`;
                    subtotalElOngkir.textContent = `Subtotal: Rp ${subTotalOngkir.toLocaleString()}`;
                    totalEl.textContent = `Total: Rp ${grandTotal.toLocaleString()}`;
                    document.getElementById("shippingCost").textContent = shipping.toLocaleString();
                    document.getElementById("appFee").textContent = appFee.toLocaleString();

                    distance = distanceKm;
                    duration = durationText
                    tarif = grandTotal;

                    // Setelah subtotal dihitung:
                    checkSaldoEligibility(userBalance, tarif);
                    // alert(`userBalance: ${userBalance}, tarif: ${tarif}`);
                })
                .catch((err) => console.error(err));
            try {} catch (err) {
                // console.error("Error geocoding:", err);
                NotifAndroidApp("Error geocoding", err);
                // if (locationText)
                //     locationText.textContent = `Lat: ${Latitude}, Lon: ${Longitude}`;
            }
        }

        async function getNamaTempat() {
            try {
                if (typeof google === "undefined") {
                    console.warn("Google Maps belum siap.");
                    return;
                }

                const getLocation = await getCurrentLocationFetchOnly();
                const status = getLocation.status;

                // ambil lat/lng dari global (di-set sebelumnya)
                lat = typeof Latitude !== "undefined" ? Latitude : null;
                lng = typeof Longitude !== "undefined" ? Longitude : null;

                // safety: kalau belum ada lokasi restoran, minta load dulu
                if (typeof window.restaurantLat === "undefined" || typeof window.restaurantLng === "undefined") {
                    console.warn("Lokasi restoran belum tersedia (window.restaurantLat / restaurantLng).");
                    // kamu bisa panggil loadRestaurantLocation() di luar fungsi ini sebelum memanggil getNamaTempat
                }

                const dstLatLng = lat !== null && lng !== null ? new google.maps.LatLng(lat, lng) : null;
                const pickupLatLng = (typeof window.restaurantLat !== "undefined" && typeof window.restaurantLng !== "undefined") ?
                    new google.maps.LatLng(window.restaurantLat, window.restaurantLng) :
                    null;

                // ========================
                // Autocomplete (buat sekali saja)
                // ========================
                if (typeof deliveryAddress === "undefined" || !deliveryAddress) {
                    console.warn("Elemen input alamat (deliveryAddress) tidak ditemukan.");
                } else {
                    // jika belum ada autocomplete global, buat; kalau sudah ada, update bounds saja
                    const acOptions = {
                        types: ["geocode"],
                        componentRestrictions: {
                            country: "id"
                        },

                        // 🔥 PENTING: Prioritaskan pencarian dari lokasi user
                        locationBias: {
                            lat: lat,
                            lng: lng
                        }
                    };

                    if (!window._alfa_autocomplete) {
                        window._alfa_autocomplete = new google.maps.places.Autocomplete(deliveryAddress);
                        window._alfa_autocomplete.setFields(["name", "formatted_address", "geometry"]);


                        window._alfa_autocomplete.addListener("place_changed", function() {
                            const place = window._alfa_autocomplete.getPlace();
                            if (!place || !place.geometry) {
                                console.warn("Lokasi tidak valid (place.geometry kosong).");
                                return;
                            }

                            // update posisi tujuan dari pilihan user
                            lat = place.geometry.location.lat();
                            lng = place.geometry.location.lng();




                            // Pilih nama tempat (lebih singkat) atau alamat kalau tidak ada nama
                            const displayName = place.name || place.formatted_address;
                            deliveryAddress.value = displayName;

                            secondAddressDestination = `${displayName}, ${place.formatted_address}`;

                            // tampilkan alamat lengkap ke input
                            // deliveryAddress.value = place.formatted_address || deliveryAddress.value;


                            // hitung ulang ongkos: start = restoran, end = pilihan user
                            if (pickupLatLng) {
                                const tujuanBaru = new google.maps.LatLng(lat, lng);
                                // Geser map ke lokasi saya

                                if (selectMapIdleListener) {
                                    google.maps.event.removeListener(selectMapIdleListener);
                                    selectMapIdleListener = null;
                                }


                                if (selectMap) selectMap.panTo(tujuanBaru);
                                calcAndUpdateCosts(pickupLatLng, tujuanBaru).catch(err => console.error(err));
                            }

                        });
                    }

                    //Set bounds berdasarkan circle 5km dari user (kalau ada)
                    if (dstLatLng && window._alfa_autocomplete) {
                        const circle = new google.maps.Circle({
                            center: dstLatLng,
                            radius: 5000
                        });
                        window._alfa_autocomplete.setBounds(circle.getBounds());
                    }
                }

                // jika Google mengembalikan alamat awal, isi input
                if (status === "OK" && getLocation.results && getLocation.results.length > 0) {
                    const fullAddress = getLocation.results[0].formatted_address;
                    const shortAddress = fullAddress.split(",")[0];
                    secondAddressDestination = fullAddress;
                    if (deliveryAddress) deliveryAddress.value = shortAddress;
                }

                // hitung ongkir awal (start restoran -> tujuan user)
                if (pickupLatLng && dstLatLng) {
                    await calcAndUpdateCosts(pickupLatLng, dstLatLng);
                }
            } catch (err) {
                console.error("getNamaTempat error:", err);
                NotifAndroidApp && NotifAndroidApp("Error geocoding", err);
            }
        }

        /* helper: hitung route lalu update UI (mengumpulkan kode update UI yang kamu pakai) */
        async function calcAndUpdateCosts(startLatLng, endLatLng) {
            try {
                const {
                    durationText,
                    distanceM,
                    distanceKm
                } = await calcRoute(startLatLng, endLatLng);
                // hitung shipping
                shipping = hitungOngkos(distanceKm, 'food');

                const appFee = 1000;
                const subTotalOngkir = shipping + appFee;
                const grandTotal = subtotal + shipping + appFee;

                // update UI (pastikan elemen-elemen ini ada di scope)
                if (subtotalEl) subtotalEl.textContent = `Subtotal: Rp ${subtotal.toLocaleString()}`;
                if (subtotalElOngkir) subtotalElOngkir.textContent = `Subtotal: Rp ${subTotalOngkir.toLocaleString()}`;
                if (totalEl) totalEl.textContent = `Total: Rp ${grandTotal.toLocaleString()}`;
                const shipEl = document.getElementById("shippingCost");
                const appFeeEl = document.getElementById("appFee");
                if (shipEl) shipEl.textContent = shipping.toLocaleString();
                if (appFeeEl) appFeeEl.textContent = appFee.toLocaleString();


                // simpan variabel global dipakai payload
                distance = distanceKm;
                duration = durationText;
                tarif = grandTotal;
                window.shipping = shipping; // jaga agar dipakai di checkSaldoEligibility

                // cek saldo user
                checkSaldoEligibility(userBalance, tarif);
                return {
                    durationText,
                    distanceM,
                    distanceKm
                };
            } catch (err) {
                console.error("calcAndUpdateCosts error:", err);
                throw err;
            }
        }


        if (!cartData.items || cartData.items.length === 0) {
            emptyNotice.style.display = "block";
            document.querySelectorAll(".checkout-section, .btn-pesan").forEach(el => el.style.display = "none");
            return;
        }

        const restoId = cartData.restaurant_id;
        // 🔥 Ambil data restoran dari server (termasuk lat/lng)
        async function loadRestaurantLocation() {
            try {
                const res = await fetch(`/api/alfafood/restaurants/${restoId}`);
                const json = await res.json();

                if (json.status && json.data) {
                    window.restaurantLat = json.data.loc_lat;
                    window.restaurantLng = json.data.loc_lng;

                    console.log("Lokasi restoran = ", window.restaurantLat, window.restaurantLng);
                    // alert("Lokasi restoran = ", window.restaurantLat, window.restaurantLng);
                } else {
                    console.warn("Tidak bisa memuat data restoran.");
                }
            } catch (e) {
                console.error("Gagal load lokasi restoran", e);
            }
        }

        loadRestaurantLocation();

        backBtn.addEventListener("click", () => {
            window.location.href = `/alfafood/${restoId}/menus`;
        });

        restNameEl.textContent = cartData.restaurant_name || "Restoran";

        let subtotal = 0;
        cartData.items.forEach(item => {
            const el = document.createElement("div");
            el.className = "order-item";
            const itemTotal = item.qty * item.price;
            subtotal += itemTotal;

            el.innerHTML = `
            <div>
                <span><strong>${item.name}</strong> × ${item.qty}</span>
                ${item.note && item.note.trim() !== ""
                    ? `<div class="order-note">
                        <strong>Catatan:</strong>
                        <div class="order-note-text">${item.note}</div>
                    </div>`
                    : ""}
            </div>
            <span>Rp ${itemTotal.toLocaleString()}</span>
        `;
            orderItemsEl.appendChild(el);
        });




        document.getElementById("btnPesan").addEventListener("click", async () => {
            const payload = {
                customer_phone: phone,
                token: token,
                restaurant_id: cartData.restaurant_id,
                restaurant_name: restNameEl.textContent,
                address: document.getElementById("deliveryAddress").value.trim(),
                restaurantLat: window.restaurantLat,
                restaurantLng: window.restaurantLng,
                distance: distance,
                duration: duration,
                tarif: tarif,
                destination_lat: lat,
                destination_lng: lng,
                destination_address: secondAddressDestination,
                payment_method: document.querySelector("input[name='payment']:checked").value,
                items: cartData.items,
                shipping_cost: shipping,
                app_fee: 1000,
                total_amount: shipping + 1000 + cartData.items.reduce((sum, i) => sum + i.qty * i.price, 0)
            };


            console.log(`Payload: ${tarif}`);

            if (!payload.address) {
                alert("⚠️ Alamat pengantaran belum diisi!");
                return;
            }

            try {
                lockOrderUI();
                setOrderButtonState("loading");

                const res = await fetch("/api/orders", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json"
                    },
                    body: JSON.stringify(payload)
                });

                const result = await res.json();

                // 🟡 Jika menu tidak tersedia
                if (result.status === "error" && result.type === "menu_unavailable") {
                    alert("⚠️ " + result.message);
                    // kembali ke halaman menu, tetap bawa cartData
                    window.location.href = `/alfafood/${cartData.restaurant_id}/menus`;
                    // window.location.href = `/alfafood`;
                    return;
                }

                // 🟡 Jika stok kurang
                if (result.status === "error" && result.type === "stock_not_enough") {
                    alert("⚠️ " + result.message);
                    window.location.href = `/alfafood/${cartData.restaurant_id}/menus`;
                    return;
                }

                // 🟢 Jika sukses
                if (result.status === "success") {

                    // 🔥 ubah tombol jadi status menunggu resto
                    setOrderButtonState("waiting");

                    // // simpan order aktif (penting untuk tracking)
                    // localStorage.setItem("activeOrder", JSON.stringify({
                    //     order_id: result.order_id,
                    //     status: "waiting_confirmation"
                    // }));

                    // // redirect tracking (boleh delay sedikit biar UX halus)
                    // setTimeout(() => {
                    //     window.location.href = `/alfafood/tracking/${result.order_id}`;
                    // }, 1200);

                }
                if (result.status !== "success") {
                    alert(result.message || "Gagal menyimpan pesanan!");
                    setOrderButtonState("normal");
                }

            } catch (err) {
                alert(result.message || "Gagal menyimpan pesanan!");
                setOrderButtonState("normal");
                console.error(err);
            }
        });

        let userBalance = 0;
        window.addEventListener("msgFromServer", function(e) {
            const data = e.detail;
            const msgType = data.action;
            const msg = data.message;

            if (msgType == "cek_data" && msg.user.saldo) {
                userBalance = Number(msg.user.saldo);
                document.getElementById("saldoInfo").textContent =
                    "Rp " + userBalance.toLocaleString();

            } else if (msgType == "resto_accept_order") {
                setOrderButtonState("accepted");
            } else if (msgType == "resto_ready_order") {
                setOrderButtonState("waiting_driver");
            } else if (msgType == "driver_to_restaurant") {
                setOrderButtonState("driver_to_restaurant");
            } else if (msgType == "on_delivery") {
                setOrderButtonState("on_delivery");
            } else if (msgType == "completed") {

                // 🧹 Bersihkan data order & cart
                // localStorage.removeItem("cartData");
                // localStorage.removeItem("activeOrder");

                // (opsional) kalau mau bersih total:
                localStorage.clear();

                // 🔁 Redirect ke halaman utama
                window.location.href = "/alfafood";
            }


        });

        function checkSaldoEligibility(userBalance, tarif) {
            const saldoOption = document.getElementById("saldoOption");
            const saldoInput = document.getElementById("paymentSaldo");

            const subtotalItems = cartData.items.reduce((s, i) => s + i.qty * i.price, 0);
            const shipping = window.shipping || 0;
            const appFee = 1000;
            const totalNeeded = subtotalItems + shipping + appFee;

            if (userBalance < totalNeeded || userBalance < tarif) {
                // SALDO TIDAK CUKUP → DISABLE
                saldoOption.classList.add("disabled");
                saldoInput.checked = false;
                saldoInput.disabled = true;
            } else {
                // SALDO CUKUP → ENABLE
                saldoOption.classList.remove("disabled");
                saldoInput.disabled = false;
            }
        }


        if (deliveryAddress) {
            deliveryAddress.addEventListener("focus", () => {
                deliveryAddress.value = ""; // kosongkan input
            });
        }

        document.getElementById("btnMyLocation").addEventListener("click", chooseCurrentLocation);


        // 📍 Tombol Lokasi Saya
        async function chooseCurrentLocation() {
            const loc = await getCurrentLocationFetchOnly();
            if (!loc || loc.status !== "OK") {
                alert("Gagal mendapatkan lokasi!");
                return;
            }

            const full = loc.results[0].formatted_address;
            deliveryAddress.value = full.split(",")[0];

            lat = Latitude;
            lng = Longitude;

            // update biaya pengiriman
            const tujuan = new google.maps.LatLng(lat, lng);
            const pickup = new google.maps.LatLng(window.restaurantLat, window.restaurantLng);

            calcAndUpdateCosts(pickup, tujuan);

            if (selectMapIdleListener) {
                google.maps.event.removeListener(selectMapIdleListener);
                selectMapIdleListener = null;
            }


            if (selectMap) selectMap.panTo(tujuan);

        }

        document.getElementById("btnPickFromMap").addEventListener("click", chooseFromMap);

        // let selectMap;
        let selectMarker;

        // ===========================
        // 📍 Pilih dari peta
        // ===========================
        function chooseFromMap() {
            const container = document.getElementById("mapSelectContainer");
            const wrapper = document.querySelector(".map-border");
            const btnPick = document.getElementById("btnPickFromMap");

            // Jika sudah terbuka → tutup
            if (container.classList.contains("show")) {
                wrapper.classList.remove("show");
                hideSelectMap();
                return;
            }

            // Jika sudah terbuka → tutup
            if (container.classList.contains("show")) {
                wrapper.classList.remove("show");
                container.classList.remove("show");

                btnPick.innerHTML = `<i class="fa-solid fa-map"></i> Pilih dari Maps`;

                hideSelectMap();
                return;
            }

            // Jika ditutup → buka
            container.classList.add("show");
            wrapper.classList.add("show");

            btnPick.innerHTML = `<i class="fa-solid fa-xmark"></i> Tutup Maps`;

            if (!selectMap) {
                initSelectMap();
            } else {
                if (!fixedCenterMarker) {
                    fixedCenterMarker = document.createElement("img");
                    fixedCenterMarker.src = "https://maps.google.com/mapfiles/ms/icons/red-dot.png";
                    fixedCenterMarker.className = "fixed-center-marker";
                    container.appendChild(fixedCenterMarker);
                }

                if (!selectMapIdleListener) {
                    attachIdleListener();
                }
            }
        }

        function attachIdleListener() {
            selectMapIdleListener = selectMap.addListener("idle", () => {
                const center = selectMap.getCenter();
                if (!center) return;

                const latlng = {
                    lat: center.lat(),
                    lng: center.lng()
                };

                lat = latlng.lat;
                lng = latlng.lng;

                // Reverse geocode
                const g = new google.maps.Geocoder();
                g.geocode({
                    location: latlng
                }, (results, status) => {
                    if (status === "OK" && results[0]) {
                        const full = results[0].formatted_address;
                        const parts = full.split(",");

                        const firstPart = parts[0].trim();
                        const secondPart = parts[1] ? parts[1].trim() : full;

                        deliveryAddress.value = firstPart.includes("+") ? secondPart : firstPart;
                    }
                });

                // Hitung ongkos kirim
                const pickup = new google.maps.LatLng(window.restaurantLat, window.restaurantLng);
                calcAndUpdateCosts(pickup, new google.maps.LatLng(lat, lng));
            });
        }

        // ===========================
        // 🗺 Inisialisasi Map Pilih Lokasi
        // ===========================

        // let fixedCenterMarker = null;
        // let selectMap = null;

        let fixedCenterMarker = null;
        let selectMap = null;
        let selectMapIdleListener = null;

        function hideSelectMap() {
            const container = document.getElementById("mapSelectContainer");
            const wrapper = document.querySelector(".map-border");

            wrapper.classList.remove("show");
            container.classList.remove("show");

            if (fixedCenterMarker) {
                fixedCenterMarker.remove();
                fixedCenterMarker = null;
            }

            if (selectMapIdleListener) {
                google.maps.event.removeListener(selectMapIdleListener);
                selectMapIdleListener = null;
            }

            document.getElementById("btnPickFromMap").innerHTML =
                `<i class="fa-solid fa-map"></i> Pilih dari maps`;

        }

        function initSelectMap() {
            selectMap = new google.maps.Map(document.getElementById("selectMap"), {
                center: {
                    lat: Latitude,
                    lng: Longitude
                },
                zoom: 16,
                disableDefaultUI: true,
                gestureHandling: "greedy"
            });

            // Buat marker fixed
            fixedCenterMarker = document.createElement("img");
            fixedCenterMarker.src = "https://maps.google.com/mapfiles/ms/icons/red-dot.png";
            fixedCenterMarker.className = "fixed-center-marker";
            document.querySelector(".marker-wrapper").appendChild(fixedCenterMarker);

            // Listener idle pertama kali
            attachIdleListener();

            // 🔥 Aktifkan idle listener kembali kalau map digeser
            selectMap.addListener("dragstart", () => {
                if (!selectMapIdleListener) {
                    attachIdleListener();
                    console.log("Idle listener aktif lagi setelah dragstart");
                }
            });
        }

        function setOrderButtonState0(state) {
            const btn = document.getElementById("btnPesan");
            const text = btn.querySelector(".btn-text");
            const spinner = btn.querySelector(".btn-spinner");

            if (state === "loading") {
                btn.classList.add("disabled");
                btn.disabled = true;
                text.textContent = "Mengirim Pesanan...";
                spinner.classList.remove("hidden");
            }

            if (state === "waiting") {
                btn.classList.add("disabled");
                btn.disabled = true;
                text.textContent = "Menunggu Konfirmasi Restoran...";
                spinner.classList.remove("hidden");
            }

            if (state === "normal") {
                btn.classList.remove("disabled");
                btn.disabled = false;
                text.textContent = "Pesan Sekarang";
                spinner.classList.add("hidden");
            }
        }

        function setOrderButtonState(state) {
            const btn = document.getElementById("btnPesan");
            const text = btn.querySelector(".btn-text");
            const spinner = btn.querySelector(".btn-spinner");

            // reset default
            btn.classList.add("disabled");
            btn.disabled = true;
            spinner.classList.remove("hidden");

            switch (state) {
                case "loading":
                    text.textContent = "Mengirim Pesanan...";
                    break;

                case "waiting":
                    text.textContent = "Menunggu Konfirmasi Restoran...";
                    break;

                case "accepted":
                    text.textContent = "Pesanan Diterima Restoran";
                    spinner.classList.add("hidden"); // tidak perlu loading
                    break;

                case "waiting_driver":
                    text.textContent = "Sedang Mencari Driver...";
                    spinner.classList.remove("hidden");
                    break;

                case "driver_to_restaurant":
                    text.textContent = "Driver Menuju Restoran";
                    break;

                case "on_delivery":
                    text.textContent = "Driver Sedang Mengantar Pesanan";
                    spinner.classList.add("hidden");
                    break;

                case "normal":
                    btn.classList.remove("disabled");
                    btn.disabled = false;
                    text.textContent = "Pesan Sekarang";
                    spinner.classList.add("hidden");
                    break;
            }
        }


    });

    function lockOrderUI() {
        // 🔒 Lock alamat & map
        deliveryAddress.disabled = true;
        document.querySelector(".location-btn-group").style.display = "none";
        document.querySelector(".map-border").style.display = "none";

        // 🔒 Ambil metode pembayaran yang DIPILIH
        const selectedPayment = document.querySelector("input[name='payment']:checked")?.value;

        const saldoOption = document.getElementById("saldoOption");
        const saldoInput = document.getElementById("paymentSaldo");
        const tunaiOption = document.querySelector('input[value="Tunai"]')?.closest(".pm-option");

        // 🔥 LOGIKA INTI
        if (selectedPayment === "Tunai") {
            // Jika TUNAI → sembunyikan saldo
            saldoOption.style.display = "none";
        }

        if (selectedPayment === "Saldo") {
            // Jika SALDO → disable saldo & sembunyikan tunai
            saldoInput.disabled = true;
            if (tunaiOption) tunaiOption.style.display = "none";
        }

        // 🔒 Disable semua radio payment
        document.querySelectorAll("input[name='payment']").forEach(radio => {
            radio.disabled = true;
        });
    }
</script>

<?= $this->endSection() ?>