<?php

namespace App\Models;

use CodeIgniter\Model;

class UlasanModel extends Model
{
    protected $table = 'ulasan_driver';
    protected $allowedFields = ['driver_phone', 'order_id', 'rating', 'ulasan', 'created_at'];

    // Hitung rata-rata rating dan total ulasan driver
    public function getAverageRating($driver_phone)
    {
        return $this->select('ROUND(AVG(rating), 1) AS avg_rating, COUNT(*) AS total_review')
            ->where('driver_phone', $driver_phone)
            ->first();
    }
    public function getAverageRatingDriver($phone)
    {
        return $this->select('ROUND(AVG(rating), 1) AS avg_rating_driver, COUNT(*) AS total_review')
            ->where('driver_phone', $phone)
            ->first();
    }
}
