<?php

namespace App\Models;

use CodeIgniter\Model;

class RiwayatDriverModel extends Model
{
    protected $table      = 'riwayat_driver';
    protected $primaryKey = 'id';

    /**
     * Ambil riwayat pendapatan driver hari ini
     *
     * @param string $phone
     * @return array
     */
    public function getRiwayat(string $phone): array
    {
        return $this->select('IFNULL(SUM(pendapatan_driver),0) AS total_pendapatan, COUNT(*) AS total_order')
            ->where('phone', $phone)
            ->where('created_at >=', date('Y-m-d 00:00:00'))
            ->where('created_at <', date('Y-m-d 23:59:59'))
            ->first() ?? [
                'total_pendapatan' => 0,
                'total_order'      => 0
            ];
    }
}
