<?php

namespace App\Models;

use CodeIgniter\Model;

class RestaurantModel extends Model
{
    protected $table = 'restaurants';
    protected $primaryKey = 'id';   
    protected $allowedFields = [
        'name',
        'restaurant_id',
        'description',
        'category',
        'address',
        'rating',
        'total_reviews',
        'logo_url',
        'open',          // <--- WAJIB TAMBAH
        'created_at',
        'email',
        'loc_lat',
        'loc_lng'
    ];


    public function getRestaurantByUserPhone($phone)
    {
        return $this->db->table('restaurants')
            ->select('restaurants.*, users.phone')
            ->join('users', 'users.restaurant_id = restaurants.id')
            ->where('users.phone', $phone)
            ->get()
            ->getRowArray();
    }
}
