<?php

namespace App\Libraries;

use App\Controllers\BaseController;
use WebSocket\Client;

class WebSocketClient extends BaseController
{
    
    /**
     * Kirim data order ke WebSocket
     */

    public function sendOrder(array $payload): bool
    {
        try {
            $ws = new Client($this->wsURL, [
                'timeout' => 5
            ]);

            $ws->send(json_encode([
                'type'    => 'order',
                'action'  => $payload['action'],
                'phone'   => $payload['phone'],
                'token'   => $payload['token'],
                'authKey' => $this->wsAuthKey,
                'msg'     => json_encode($payload['data'])
            ]));

            $ws->close();
            return true;
        } catch (\Throwable $e) {
            log_message('error', '[WebSocket] ' . $e->getMessage());
            return false;
        }
    }
}
