<?php

namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

use App\Models\UserModel;

class AuthFilter implements FilterInterface 
{
    public function before(RequestInterface $request, $arguments = null)
    {
            // Ambil token dari header
        $authHeader = $request->getHeaderLine('Authorization');
        $token = str_replace('Bearer ', '', $authHeader);
        
        // Jika tidak ada token → cek session
        if (!$token) {
            $userSession = session('user');
            $token = $userSession['token'] ?? null;
            $phone = $userSession['phone'] ?? null;

            // dd($phone);
        }
      
        // Jika tetap tidak ada token
        if (!$token) {
            session()->setFlashdata('error', 'Silakan login untuk melanjutkan.');
            return redirect()->to('/login');
        }

        // Cek database
        $userModel = new UserModel();
        $user = $userModel->where('phone', $phone)->first();
       
        if ($user && $token != $user["token"]){
            // dd($token);
            session()->remove('user');

            // Kirim pesan session habis
            session()->setFlashdata('error', 'Session Anda telah habis, silakan login kembali.');

            return redirect()->to('/login');
        }    
       

        // Simpan data user ke session
        // session()->set('user', $user);

        return;
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null) {}
}
