<?php

namespace App\Controllers;

use CodeIgniter\CLI\Console;
use CodeIgniter\Controller;
// use App\Models\RestaurantModel;
// use App\Models\UlasanModel;
// use App\Models\UserModel;
use Predis\Command\Traits\Get\Get;
use WebSocket\Client;



class Restaurant extends BaseController
{

    public function index()
    {
        $user = $this->userModel
            ->where('phone', $this->phone)
            ->first();
        $auto_bid_resto = $user["auto_bid_resto"];

        $restaurant = $this->restaurantModel->getRestaurantByUserPhone($this->phone);

        // ===============================
        //  HITUNG MENU
        // ===============================

        $totalMenu = $this->menuModel->where('restaurant_id', $restaurant['id'])->countAllResults();

        $availableMenu = $this->menuModel->where('restaurant_id', $restaurant['id'])
            ->where('available', 1)
            ->countAllResults();

        $notAvailableMenu = $this->menuModel->where('restaurant_id', $restaurant['id'])
            ->where('available', 0)
            ->countAllResults();

        // ===============================
        //  KIRIM KE VIEW
        // ===============================

        return view('restaurants/restaurant_dashboard', [
            'restaurant'        => $restaurant,
            'restaurant_id'     => $restaurant['id'],
            'open'              => $restaurant['open'],
            'auto_bid_resto'    => $auto_bid_resto,

            // 🔥 New Stats
            'menu_total'        => $totalMenu,
            'menu_available'    => $availableMenu,
            'menu_not_available' => $notAvailableMenu,

            // rating
            'rating' => $this->userData['avg_rating_restaurant'],
            'review' => $this->userData['total_review_restaurant']
        ]);
    }

    public function order()
    {
        // ===============================
        // DUMMY DATA ORDER (FROM USER)
        // ===============================
        $orders = [
            [
                "id" => "INV202401",
                "customer_name" => "Budi Pratama",
                "driver_name" => null,
                "pin_code" => null,
                "payment_method" => "Tunai",
                "items" => [
                    [
                        "name" => "Ayam Geprek",
                        "qty"  => 1,
                        "note" => "Pedas level 3\nJangan terlalu asin\nSambal dipisah"
                    ],
                    [
                        "name" => "Es Teh Manis",
                        "qty"  => 2,
                        "note" => "Kurangi gula"
                    ],
                ],
                "price" => 28000,
                "datetime" => "2025-01-20 14:32",
                "status" => "waiting"
            ],

            [
                "id" => "INV202402",
                "customer_name" => "Siti Aminah",
                "driver_name" => null,
                "pin_code" => null,
                "payment_method" => "QRIS",
                "items" => [
                    [
                        "name" => "Soto Lamongan",
                        "qty"  => 1,
                        "note" => ""
                    ],
                    [
                        "name" => "Kerupuk",
                        "qty"  => 1,
                        "note" => ""
                    ]
                ],
                "price" => 22000,
                "datetime" => "2025-01-20 15:12",
                "status" => "process"
            ],

            [
                "id" => "INV202403",
                "customer_name" => "Dedy Kurniawan",
                "driver_name" => "Driver Ahmad",
                "pin_code" => "4821",
                "payment_method" => "Tunai",
                "items" => [
                    [
                        "name" => "Bakso Jumbo",
                        "qty"  => 2,
                        "note" => "Tidak pakai daun bawang"
                    ]
                ],
                "price" => 40000,
                "datetime" => "2025-01-20 15:50",
                "status" => "driver"
            ],

            [
                "id" => "INV202405",
                "customer_name" => "Rahmat Hidayat",
                "driver_name" => "Driver Asep",
                "pin_code" => "3348",
                "payment_method" => "Tunai",
                "items" => [
                    [
                        "name" => "Nasi Goreng Spesial",
                        "qty"  => 1,
                        "note" => ""
                    ],
                    [
                        "name" => "Teh Tarik",
                        "qty"  => 1,
                        "note" => "Sambal terpisah ya"
                    ]
                ],
                "price" => 30000,
                "datetime" => "2025-01-20 16:45",
                "status" => "done"
            ],
        ];

        return view("restaurants/order", [
            "orders" => $orders
        ]);
    }

    public function Menu0()
    {
        return view('restaurants/menus');
    }
    public function Menu()
    {
        $restaurantId = $this->request->getGet('restaurant_id');

        $menus = $this->menuModel
            ->where('restaurant_id', $restaurantId)
            ->orderBy('available', 'DESC') // 1 di atas, 0 di bawah
            ->findAll();


        // dd($menus); // 🔎 cek hasil sebelum ke view

        // Jika menu kosong → redirect ke tambah menu
        if (!$menus) {
            return redirect()->to(
                "/restaurant_menu_add?restaurant_id=" . $restaurantId
            )
                ->with('menu_empty', true)
                ->with('restaurant_id', $restaurantId)
                ->with('message', 'Menu masih kosong, silakan tambah menu.');
        }


        return view('restaurants/menus', [
            'menus' => $menus,
            'restaurant_id' => $restaurantId,
        ]);
    }

    public function AddMenu0()
    {
        $restaurantId = $this->request->getGet('restaurant_id');
        $token = $this->request->getGet('token');
        $phone = $this->request->getGet('phone');

        return view('restaurants/add_menu', [
            'menu_empty' => false,
            'restaurant_id' => $restaurantId,
            'token' => $token,
            'phone' => $phone
        ]);
    }
    public function addMenu()
    {
        $restaurantId = $this->request->getGet('restaurant_id');
        $token        = $this->request->getGet('token');
        $phone        = $this->request->getGet('phone');
        $menuId       = $this->request->getGet('menu_id');



        // Jika method POST → proses penyimpanan
        if ($this->request->getMethod() === 'POST') {


            // ========== UPLOAD GAMBAR ==========
            $image = $this->request->getFile('image');


            $imageUrl = null;
            if ($image && $image->isValid() && !$image->hasMoved()) {
                $newName = $image->getRandomName();
                $image->move(FCPATH . 'uploads/menus', $newName);
                $imageUrl = '/uploads/menus/' . $newName;
            }

            // ========== SIMPAN DATA ==========
            $this->menuModel->save([
                'restaurant_id' => $restaurantId,
                'name'          => $this->request->getPost('name'),
                'category'      => $this->request->getPost('category'),
                'price'         => $this->request->getPost('price'),
                'description'   => $this->request->getPost('description'),
                'available'        => $this->request->getPost('available') ? 1 : 0,
                'image_url'     => $imageUrl
            ]);
            log_message('error', 'Menu saved: ' . json_encode($this->request->getPost()));


            return $this->response->setJSON(['success' => true]);

            // return redirect()->to(
            //     "/restaurant_menu?restaurant_id=" . $restaurantId .
            //         "&token=" . $token .
            //         "&phone=" . $phone
            // )->with('success', "Menu berhasil ditambahkan!");
        }

        // Jika GET → tampilkan form

        $menu = null;
        if ($menuId) {
            $menu = $this->menuModel->find($menuId);
        }
        return view('restaurants/add_menu', [
            'restaurant_id' => $restaurantId,
            'token' => $token,
            'phone' => $phone,
            "menu" => $menu
        ]);
    }

    public function updateMenu()
    {
        $menuId = $this->request->getPost('menu_id');

        if (!$menuId) {
            return $this->response->setJSON(['success' => false, 'message' => 'Menu ID tidak ditemukan']);
        }


        $menu = $this->menuModel->find($menuId);

        if (!$menu) {
            return $this->response->setJSON(['success' => false, 'message' => 'Menu tidak ditemukan']);
        }

        // Ambil data input
        $name        = $this->request->getPost('name');
        $category    = $this->request->getPost('category');
        $price       = $this->request->getPost('price');
        $description = $this->request->getPost('description');
        $available      = $this->request->getPost('available') ?? 0;

        $updateData = [
            'name'        => $name,
            'category'    => $category,
            'price'       => $price,
            'description' => $description,
            'available'      => $available,
        ];

        // ===============================
        // 1. CEK APAKAH USER UPLOAD FOTO
        // ===============================
        $file = $this->request->getFile('image');

        if ($file && $file->isValid() && !$file->hasMoved()) {

            // pastikan folder ada
            $path = FCPATH . 'uploads/menus/';
            if (!is_dir($path)) {
                mkdir($path, 0775, true);
            }

            // hapus foto lama jika ada
            if (!empty($menu['image_url'])) {
                $old = FCPATH . str_replace(base_url() . '/', '', $menu['image_url']);
                if (file_exists($old)) {
                    unlink($old);
                }
            }

            // simpan foto baru
            $newName = $file->getRandomName();
            $file->move($path, $newName);

            $updateData['image_url'] = base_url("uploads/menus/$newName");
        }

        // update database
        $this->menuModel->update($menuId, $updateData);

        return $this->response->setJSON(['success' => true]);
    }

    public function MenuList()
    {


        // Ambil id restoran dari parameter GET
        $restaurantId = $this->request->getGet('restaurant_id');

        // Jika token kosong, kembalikan error JSON
        if (!$restaurantId) {

            return $this->response->setJSON([
                "status" => false,
                "message" => "Restaurant tidak ditemukan"
            ]);
        }

        // Ambil data menu berdasarkan restoran
        $menus = $this->menuModel->where('restaurant_id', $restaurantId)->findAll();

        // Kembalikan JSON
        return $this->response->setJSON([
            "status" => true,
            "count" => count($menus),
            "data" => $menus,
        ]);
    }

    public function ToggleMenuStatus0($menuId)
    {
        $model = new \App\Models\MenuModel();

        // Cek apakah menu ada
        $menu = $model->find($menuId);

        if (!$menu) {
            return $this->response->setJSON([
                "status" => false,
                "message" => "Menu tidak ditemukan"
            ]);
        }

        // Toggle active (1 menjadi 0, 0 menjadi 1)
        $newStatus = $menu['available'] == 1 ? 0 : 1;

        // Update DB
        $model->update($menuId, [
            'available' => $newStatus
        ]);

        return $this->response->setJSON([
            "status" => true,
            "menu_id" => $menuId,
            "available" => $newStatus
        ]);
    }
    public function ToggleMenuStatus($id)
    {


        $menu = $this->menuModel->find($id);
        if (!$menu) {
            return $this->response->setJSON(['success' => false]);
        }

        $newStatus = $menu['available'] == 1 ? 0 : 1;

        $this->menuModel->update($id, ['available' => $newStatus]);

        return $this->response->setJSON([
            'success' => true,
            'available' => $newStatus
        ]);
    }

    public function delete($id)
    {


        $menu = $this->menuModel->find($id);


        if (!$menu) {
            return $this->response->setJSON(['success' => false, 'msg' => 'Menu tidak ditemukan']);
        }

        // Hapus file gambar jika ada
        if (!empty($menu['image_url'])) {
            $path = FCPATH . $menu['image_url'];
            if (file_exists($path)) unlink($path);
        }

        // Hapus data
        $this->menuModel->delete($id);

        return $this->response->setJSON(['success' => true]);
    }

    public function toggleStore()
    {
        $restaurantId = $this->request->getPost('restaurant_id');

        if (!$restaurantId) {
            return $this->response->setJSON([
                'success' => false,
                'msg' => 'Restaurant ID tidak ditemukan'
            ]);
        }



        // Ambil status saat ini
        $resto = $this->restaurantModel->find($restaurantId);
        if (!$resto) {
            return $this->response->setJSON([
                'success' => false,
                'msg' => 'Restoran tidak ditemukan'
            ]);
        }

        // Toggle status
        $newStatus = $resto['open'] ? 0 : 1;

        $this->restaurantModel->update($restaurantId, [
            'open' => $newStatus
        ]);

        return $this->response->setJSON([
            'success' => true,
            'newStatus' => $newStatus,
            'msg' => $newStatus ? "Restoran dibuka" : "Restoran ditutup"
        ]);
    }

    public function OrderAccept0()
    {
        $id = $this->request->getJSON()->id ?? null;

        if (!$id) {
            return $this->response->setJSON([
                "success" => false,
                "message" => "ID pesanan tidak ditemukan"
            ]);
        }


        $order = $this->orderModel->find($id);

        if (!$order) {
            return $this->response->setJSON([
                "success" => false,
                "message" => "Pesanan tidak ditemukan"
            ]);
        }

        $payload = [
            "action" => "resto_accept_order"
        ];

        $this->ws->sendOrder([
            'action' => 'food',
            'phone'  => $this->phone,
            'token'  => $this->token,
            'data'   => $payload
        ]);

        // Ubah status ke process
        $this->orderModel->update($id, [
            "order_status" => "process",
            "updated_at" => date("Y-m-d H:i:s")
        ]);


        // window.AndroidApp.sendMessageToServerFromWebview("order", "ride", JSON.stringify({
        //     action: "accept",
        //     customerPhone: customerPhone,
        //     // driver_phone:driverPhone;
        //     orderID: orderID
        // }));


        return $this->response->setJSON([
            "success" => true,
            "message" => "Pesanan diterima",
            "status" => "process"
        ]);
    }
    public function OrderAccept()
    {
        $id = $this->request->getJSON()->id ?? null;

        if (!$id) {
            return $this->response->setJSON([
                "success" => false,
                "message" => "ID pesanan tidak ditemukan"
            ]);
        }

        $order = $this->orderModel->find($id);

        if (!$order) {
            return $this->response->setJSON([
                "success" => false,
                "message" => "Pesanan tidak ditemukan"
            ]);
        }

        // ➕ Tambah field action ke order
        $order['action'] = 'resto_accept_order';

        $this->ws->sendOrder([
            'action' => 'food',
            'phone'  => $this->phone,
            'token'  => $this->token,
            'data'   => $order
        ]);

        // Update status
        $this->orderModel->update($id, [
            "order_status" => "process",
            "updated_at"   => date("Y-m-d H:i:s")
        ]);

        return $this->response->setJSON([
            "success" => true,
            "message" => "Pesanan diterima",
            "status"  => "process"
        ]);
    }

    public function OrderReady0()
    {
        $json = $this->request->getJSON(true);
        $id = $json["id"] ?? null;

        if (!$id) {
            return $this->response->setJSON([
                "success" => false,
                "message" => "Order ID missing"
            ]);
        }

        $orderModel = new \App\Models\OrderModel();

        $order = $orderModel->find($id);
        if (!$order) {
            return $this->response->setJSON([
                "success" => false,
                "message" => "Order tidak ditemukan"
            ]);
        }

        // Ubah status ke driver
        $orderModel->update($id, [
            "order_status" => "driver",
            "updated_at"   => date("Y-m-d H:i:s")
        ]);

        return $this->response->setJSON([
            "success" => true,
            "message" => "Pesanan siap & menunggu driver",
            "status"  => "driver"
        ]);
    }
    public function OrderReady()
    {
        $json = $this->request->getJSON(true);
        $id = $json["id"] ?? null;

      
        if (!$id) {
            return $this->response->setJSON([
                "success" => false,
                "message" => "Order ID missing"
            ]);
        }


        $order = $this->orderModel->find($id);
        if (!$order) {
            return $this->response->setJSON([
                "success" => false,
                "message" => "Order tidak ditemukan"
            ]);
        }

        // PIN sudah ada di database? kalau belum generate
        $pin = $order["pin_code"];

        // Update
        $this->orderModel->update($id, [
            "order_status" => "searching",
            // "pin_code"     => $pin,
            "updated_at"   => date("Y-m-d H:i:s")
        ]);


        $orders = $this->orderModel->getOrders($this->restaurantId, $id);
        $restaurant =  $this->restaurantModel
            ->where('id', $orders[0]["restaurant_id"])
            ->first();

        // =============================
        // 🔥 Kirim ke WebSocket API
        // =============================
        // $this->postToWebSocketApi("api/start-find-driver", [
        //     'orderID'          => $order['order_id']

        // ]);


        // $payload = [
        //     "order_type"=>"food",
        //     "orderID" => $order['order_id'],
        //     "restaurant_id" => $order['restaurant_id'],         
        // ];

        $payload = [
            "order_type" => "food",
            "orderID" => $order['order_id'],
            "restaurant_id" => $order['restaurant_id'],
            "pickup" => $order['pickup'],
            "destination" => $order['destination'],
            "pickup_lat" => $order['pickup_lat'],
            "pickup_lng" => $order['pickup_lng'],
            "dst_lat" => $order['destination_lat'],
            "dst_lng" => $order['destination_lng'],
            "price" => $order['tarif'],
            "distance" => $order['distance'],
            "duration" => $order['duration'],
            "payment_metode" => $order['payment_metode']
        ];

        $orders[0]['order_type'] = 'food';
        $orders[0]['restaurant'] =  $restaurant;
        // $orders[0]['restaurant_loc_lng'] =  "345";
        // $orders[0]['action'] = 'resto_ready_order';


        $this->ws->sendOrder([
            'action' => 'food',
            'phone'  => $this->phone,
            'token'  => $this->token,
            'data'   => $orders[0]
        ]);


        // Kirim pin_code ke JavaScript!!
        return $this->response->setJSON([
            "success"   => true,
            "message"   => "Pesanan siap & menunggu driver",
            "status"    => "searching",
            "pin_code"  => $pin
        ]);
    }

    public function checkPin()
    {
        $data = $this->request->getJSON(true);

        $orderId = $data['order_id'] ?? null;
        $pin     = $data['pin'] ?? null;
        $driver  = $data['driver_phone'] ?? null;

        if (!$orderId || !$pin) {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'Data tidak lengkap'
            ]);
        }


        $order = $this->orderModel
            ->where('order_id', $orderId)
            ->first();

        if (!$order) {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'Order tidak ditemukan'
            ]);
        }

        // 🔐 cek PIN
        if ($order['pin_code'] !== $pin) {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'PIN restoran salah'
            ]);
        }

        // (opsional) cek driver
        if ($order['driver_phone'] !== $driver) {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'Driver tidak sesuai'
            ]);
        }

        // update status order
        $this->orderModel->update($order['id'], [
            'order_status' => 'deliver'
        ]);

        return $this->response->setJSON([
            'status' => true,
            'message' => 'PIN valid'
        ]);
    }

    public function toggleAutoAccept()
    {
        $user = $this->userModel->where('token', $this->token)->first();

        // toggle auto bid resto
        $newStatus = ($user['auto_bid_resto'] == 1) ? 0 : 1;

        $this->userModel->update(
            $user['phone'],
            [
                'auto_bid_resto' => $newStatus
            ]
        );

        return $this->response->setJSON([
            'success'   => true,
            'newStatus' => $newStatus
        ]);
    }
}
