<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\UlasanModel;

class ProfileController extends BaseController
{

    public function index()
    {

        $user = $this->userModel
            ->where('token', $this->token)
            ->first();
      
        // ✅ pastikan user ditemukan
        if (!$user) {
            return redirect()->to('/login')->with('error', 'User tidak ditemukan, silakan login ulang.');
        }

        // Ambil role dari user
        $role = $user['role'] ?? '';
        $phone =  $user['phone'] ?? '';

        // Jika user adalah driver, hitung rata-rata rating
        $ratingData = null;
        if ($role === 'driver') {
            $ulasanModel = new UlasanModel();
            $ratingData = $ulasanModel->getAverageRating($phone);
        }

        // ✅ kirim data ke view
        return view('profile', [
            'user' => $user,
            'role' => $role,
            'ratingData' => $ratingData
        ]);
    }
}
