<?php

namespace App\Controllers;
use App\Models\OtpModel;

class OtpController extends BaseController
{
    public function resendOtp()
    {
        $phone = session()->get('phone');



        if (!$phone) {
            return redirect()->back()->with('error', 'Nomor HP wajib diisi');
        }

        // Simpan nomor HP ke session
        session()->set('phone', $phone);

        $otpModel = new OtpModel();

        // Cek OTP yang belum expired
        $currentTime = date('Y-m-d H:i:s');
        $existingOtp = $otpModel
            ->where('phone', $phone)
            ->where('expired >=', $currentTime)
            ->orderBy('id', 'DESC')
            ->first();

        if ($existingOtp) {
            $otp = $existingOtp['otp'];
        } else {
            $otp = rand(100000, 999999);
            $expired = date('Y-m-d H:i:s', strtotime('+5 minutes'));

            $otpModel->insert([
                'phone' => $phone,
                'otp' => $otp,
                'expired' => $expired
            ]);
        }

        // Ubah format nomor HP ke +62 (hapus 0 di depan)
        if (substr($phone, 0, 1) == '0') {
            $phoneFormatted = '62' . substr($phone, 1);
        } else {
            $phoneFormatted = $phone;
        }

        // Kirim OTP ke API eksternal
        $client = \Config\Services::curlrequest();
        $apiUrl = 'http://localhost:3000/api/send-wa';
        $payload = [
            'pengirim' => $phoneFormatted,
            'otp' => $otp
        ];

        try {
            $response = $client->post($apiUrl, [
                'json' => $payload
            ]);
        } catch (\Exception $e) {
            log_message('error', 'Gagal kirim OTP ke API: ' . $e->getMessage());
        }
    }
    public function sendOtp($phone = null)
    {
        if (!$phone) {
            // ambil dari POST jika tidak dikirim
            $phone = $this->request->getPost('phone');
        }

        if (!$phone) {
            return $this->response->setStatusCode(400)
                ->setJSON(['status' => false, 'message' => 'Nomor HP wajib diisi']);
        }



        session()->set('phone', $phone);

        $otpModel = new OtpModel();

        // cek OTP belum expired
        $currentTime = date('Y-m-d H:i:s');
        $existingOtp = $otpModel
            ->where('phone', $phone)
            ->where('expired >=', $currentTime)
            ->orderBy('id', 'DESC')
            ->first();

        if ($existingOtp) {
            $otp = $existingOtp['otp'];
        } else {
            $otp = rand(100000, 999999);
            $expired = date('Y-m-d H:i:s', strtotime('+5 minutes'));

            $otpModel->insert([
                'phone' => $phone,
                'otp' => $otp,
                'expired' => $expired
            ]);
        }

        // Ubah format nomor HP ke +62
        $phoneFormatted = (substr($phone, 0, 1) == '0') ? '62' . substr($phone, 1) : $phone;

        // Kirim OTP ke API eksternal
        $client = \Config\Services::curlrequest();
        $apiUrl = 'http://localhost:3000/api/send-wa';
        $payload = [
            'pengirim' => $phoneFormatted,
            'otp' => $otp
        ];

        try {
            $response = $client->post($apiUrl, [
                'json' => $payload
            ]);
        } catch (\Exception $e) {
            log_message('error', 'Gagal kirim OTP ke API: ' . $e->getMessage());
        }

        return [
            'status' => true,
            'message' => 'OTP telah dikirim',
            'otp' => $otp
        ];

        // return redirect()->to('/otp')->with('message', 'Kode OTP telah dikirim ke nomor Anda');
    }


    
}



