<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\OrderModel;
use App\Models\UserModel;

helper('format');

class OrderFoodController extends BaseController
{
    public function index0()
    {

        // Ambil data order jika dikirim lewat query string (orderID)
        $orderID = $this->request->getGet('orderID');


        $user = $this->userModel
            ->where('phone', $this->phone)
            ->where('order_id', $orderID)
            ->first();

        if (!$user) {
            return redirect()->to('/driver');
        }

        $orderData = [];

        if ($orderID) {
            $orderModel = new OrderModel();
            $orderData = $orderModel->getOrders(null, $orderID);
        }
        // dd($orderData);
        return view('driver/food_order', [
            'order' => $orderData,
        ]);
    }
    public function index()
    {
        // Ambil orderID dari query string
        $orderID = $this->request->getGet('orderID');

        if (!$orderID) {
            return redirect()->to('/driver');
        }

        // Cek user + order milik driver ini
        $user = $this->userModel
            ->where('phone', $this->phone)
            ->where('order_id', $orderID)
            ->first();

        if (!$user) {
            return redirect()->to('/driver');
        }

        // Ambil order
        $orderModel = new OrderModel();
        $orders = $orderModel->getOrders(null, $orderID);

        // ⛔ Tidak ada order
        if (empty($orders)) {
            return redirect()->to('/driver');
        }

        // ✅ Ambil 1 order saja
        $order = $orders[0];
        // dd($order);

        return view('driver/food_order', [
            'order' => $order,   // ⬅️ KIRIM SATU ORDER SAJA
            'user'  => $user
        ]);
    }


    // Endpoint untuk aksi jika butuh POST
    public function action()
    {
        $action = $this->request->getPost('action');
        $orderID = $this->request->getPost('orderID');

        switch ($action) {
            case 'complete':
                // update status jika diperlukan
                return $this->response->setJSON(['status' => true]);
            default:
                return $this->response->setJSON(['status' => false]);
        }
    }
}
