<?php

namespace App\Controllers;

use App\Models\OrderModel;
use App\Models\OrderItemModel;
use App\Models\MenuModel;
use CodeIgniter\HTTP\ResponseInterface;

class OrderController extends BaseController
{
    public function create0()
    {
        // Ambil JSON body manual, kompatibel semua versi
        $json = $this->request->getBody();
        $data = json_decode($json, true);


        if (empty($data['restaurant_id']) || empty($data['address']) || empty($data['items'])) {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'Data pesanan tidak lengkap!'
            ])->setStatusCode(ResponseInterface::HTTP_BAD_REQUEST);
        }

        $orderModel = new OrderModel();
        $orderItemModel = new OrderItemModel();
        $menuModel = new MenuModel();
        $db = \Config\Database::connect();

        $db->transStart();

        // ✅ Validasi stok menu
        foreach ($data['items'] as $item) {
            $menu = $menuModel->find($item['id']);

            if (!$menu) {
                $db->transRollback();
                return $this->response->setJSON([
                    'status' => 'error',
                    'message' => "Menu '{$item['name']}' tidak ditemukan!"
                ])->setStatusCode(ResponseInterface::HTTP_BAD_REQUEST);
            }

            if ($menu['stock'] <= 0) {
                return $this->response->setJSON([
                    'status' => 'error',
                    'type' => 'menu_unavailable', // 🔹 tipe error
                    'menu_id' => $menu['id'],
                    'message' => "Menu '{$menu['name']}' sudah habis!"
                ]);
            }

            if ($menu['stock'] < $item['qty']) {
                return $this->response->setJSON([
                    'status' => 'error',
                    'type' => 'stock_not_enough', // 🔹 tipe error lain
                    'menu_id' => $menu['id'],
                    'message' => "Stok menu '{$menu['name']}' tidak mencukupi (tersisa {$menu['stock']})."
                ]);
            }
        }


        // if (empty($data['order_id'])) {
        //     $data['order_id'] = $this->generateOrderId();
        // }

        $OrderID = $this->generateOrderId();
        // ✅ Jika semua valid, simpan pesanan utama
        $orderId = $orderModel->insert([
            'order_id' => $OrderID,
            'restaurant_id' => $data['restaurant_id'],
            'address'       => $data['address'],
            'payment_method' => $data['payment_method'] ?? 'cash',
            'shipping_cost' => $data['shipping_cost'] ?? 0,
            'app_fee'       => $data['app_fee'] ?? 0,
            'total_amount'  => $data['total_amount'] ?? 0,
            'status'        => 'pending',
            'created_at'    => date('Y-m-d H:i:s'),
        ]);

        // ✅ Simpan detail item & kurangi stok
        foreach ($data['items'] as $item) {
            $orderItemModel->insert([
                'order_id' => $orderId,
                'menu_id'  => $item['id'],
                'menu_name' => $item['name'],
                'price'    => $item['price'],
                'qty'      => $item['qty'],
                'note'     => $item['note'] ?? null,
            ]);

            // Kurangi stok
            $menuModel->set('stock', 'stock - ' . (int) $item['qty'], false)
                ->where('id', $item['id'])
                ->update();
        }

        $db->transComplete();

        if ($db->transStatus() === false) {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'Gagal menyimpan pesanan!'
            ])->setStatusCode(ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
        }

        return $this->response->setJSON([
            'status' => 'success',
            'message' => 'Pesanan berhasil disimpan!',
            'order_id' => $orderId
        ]);
    }
    public function create1()
    {
        $json = $this->request->getBody();
        $data = json_decode($json, true);

        if (empty($data['restaurant_id']) || empty($data['address']) || empty($data['items'])) {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'Data pesanan tidak lengkap!'
            ])->setStatusCode(ResponseInterface::HTTP_BAD_REQUEST);
        }

        $orderModel = new OrderModel();
        $orderItemModel = new OrderItemModel();
        $menuModel = new MenuModel();
        $db = \Config\Database::connect();

        // =============================
        // 🔥 Generate order ID
        // =============================
        $OrderID = $this->generateOrderId();

        $db->transStart();

        // =============================
        // 🔍 Validasi stok
        // =============================
        foreach ($data['items'] as $item) {
            $menu = $menuModel->find($item['id']);

            if (!$menu) {
                $db->transRollback();
                return $this->response->setJSON([
                    'status' => 'error',
                    'message' => "Menu '{$item['name']}' tidak ditemukan!"
                ]);
            }

            if ($menu['available'] == 0) {
                return $this->response->setJSON([
                    'status' => 'error',
                    'type' => 'menu_unavailable',
                    'menu_id' => $menu['id'],
                    'message' => "Menu '{$menu['name']}' sudah habis!"
                ]);
            }

            // if ($menu['stock'] < $item['qty']) {
            //     return $this->response->setJSON([
            //         'status' => 'error',
            //         'type' => 'stock_not_enough',
            //         'menu_id' => $menu['id'],
            //         'message' => "Stok menu '{$menu['name']}' tidak mencukupi (tersisa {$menu['stock']})."
            //     ]);
            // }
        }

        $phone = $data['customer_phone'];
        $token = $data['token'];
        $restaurant_id = $data['restaurant_id'];

        $userModel = new \App\Models\UserModel();
        $user = $userModel
            ->where('phone', $phone)
            ->where('token', $token)
            ->first();
        $name = $user['nama'] ?? null;
        $user_lat = $user['loc_lat'] ?? null;
        $user_lng = $user['loc_lng'] ?? null;
        $saldo = $user['saldo'] ?? 0;

        if (($data['payment_method'] ?? '') === 'Saldo') {

            if ($saldo <= 0 || $saldo < $data['tarif']) {
                return $this->response->setJSON([
                    'status' => 'error',
                    'type' => 'saldo_not_enough',
                    'message' => 'Saldo Anda tidak mencukupi untuk melakukan pembayaran!'
                ]);
            }
        }



        // $restaurantModel = new \App\Models\RestaurantModel();
        // $restaurant = $restaurantModel
        //     ->where('id', $restaurant_id)           
        //     ->first();

        // $restaurant_lat = $restaurant['loc_lat'] ?? null;
        // $restaurant_lng = $restaurant['loc_lng'] ?? null;




        // =============================
        // 🔥 Insert data order utama
        // =============================
        $insertID = $orderModel->insert([
            'order_id'      => $OrderID,
            'order_type'      => 'food',
            'customer_name' => $name,
            'customer_phone' => $phone,
            'pickup' => $data['restaurant_name'],
            'destination' => $data['address'],
            'pickup_lat' => $data['restaurantLat'],
            'pickup_lng' => $data['restaurantLng'],
            'destination_lat' => $user_lat,
            'destination_lng' => $user_lng,
            'distance'       => $data['distance'],
            'address'       => $data['address'],
            'duration'       => $data['duration'],
            'tarif'       => $data['tarif'],
            'payment_metode' => $data['payment_method'] ?? 'Tunai',
            'shipping_cost' => $data['shipping_cost'] ?? 0,
            'app_fee'       => $data['app_fee'] ?? 0,
            'total_amount'  => $data['total_amount'] ?? 0,
            'order_status'        => 'new',
            'created_at'    => date('Y-m-d H:i:s'),
        ]);

        // =============================
        // 🔥 Simpan items
        // =============================
        foreach ($data['items'] as $item) {
            $orderItemModel->insert([
                'order_id'  => $insertID,
                'menu_id'   => $item['id'],
                'menu_name' => $item['name'],
                'price'     => $item['price'],
                'qty'       => $item['qty'],
                'note'      => $item['note'] ?? null,
            ]);

            // kurangi stok
            // $menuModel->set('stock', 'stock - ' . (int) $item['qty'], false)
            //     ->where('id', $item['id'])
            //     ->update();
        }

        $db->transComplete();

        if ($db->transStatus() === false) {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'Gagal menyimpan pesanan!'
            ]);
        }

        return $this->response->setJSON([
            'status' => 'success',
            'message' => 'Pesanan berhasil disimpan!',
            'order_id' => $OrderID   // ✔ ini benar!
        ]);
    }
    public function create()
    {
        $json = $this->request->getBody();
        $data = json_decode($json, true);

        if (empty($data['restaurant_id']) || empty($data['address']) || empty($data['items'])) {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'Data pesanan tidak lengkap!'
            ])->setStatusCode(ResponseInterface::HTTP_BAD_REQUEST);
        }

        $orderModel = new OrderModel();
        $orderItemModel = new OrderItemModel();
        $menuModel = new MenuModel();
        $db = \Config\Database::connect();

        // =============================
        // 🔥 Generate order ID
        // =============================
        $OrderID = $this->generateOrderId();

        $db->transStart();

        // =============================
        // 🔍 Validasi stok
        // =============================
        foreach ($data['items'] as $item) {
            $menu = $menuModel->find($item['id']);

            if (!$menu) {
                $db->transRollback();
                return $this->response->setJSON([
                    'status' => 'error',
                    'message' => "Menu '{$item['name']}' tidak ditemukan!"
                ]);
            }

            if ($menu['available'] == 0) {
                return $this->response->setJSON([
                    'status' => 'error',
                    'type' => 'menu_unavailable',
                    'menu_id' => $menu['id'],
                    'message' => "Menu '{$menu['name']}' sudah habis!"
                ]);
            }

            // if ($menu['stock'] < $item['qty']) {
            //     return $this->response->setJSON([
            //         'status' => 'error',
            //         'type' => 'stock_not_enough',
            //         'menu_id' => $menu['id'],
            //         'message' => "Stok menu '{$menu['name']}' tidak mencukupi (tersisa {$menu['stock']})."
            //     ]);
            // }
        }

        $phone = $data['customer_phone'];
        $token = $data['token'];
        $restaurant_id = $data['restaurant_id'];

        $userModel = new \App\Models\UserModel();
        $user = $userModel
            ->where('phone', $phone)
            ->where('token', $token)
            ->first();
        $name = $user['nama'] ?? null;
        $user_lat = $user['loc_lat'] ?? null;
        $user_lng = $user['loc_lng'] ?? null;
        $saldo = $user['saldo'] ?? 0;

        if (($data['payment_method'] ?? '') === 'Saldo') {

            if ($saldo <= 0 || $saldo < $data['tarif']) {
                return $this->response->setJSON([
                    'status' => 'error',
                    'type' => 'saldo_not_enough',
                    'message' => 'Saldo Anda tidak mencukupi untuk melakukan pembayaran!'
                ]);
            }
        }



        // $restaurantModel = new \App\Models\RestaurantModel();
        // $restaurant = $restaurantModel
        //     ->where('id', $restaurant_id)           
        //     ->first();

        // $restaurant_lat = $restaurant['loc_lat'] ?? null;
        // $restaurant_lng = $restaurant['loc_lng'] ?? null;


        $pin_code = rand(1000, 9999);

        // =============================
        // 🔥 Insert data order utama
        // =============================
        $insertID = $orderModel->insert([
            'order_id'          => $OrderID,
            'order_type'        => 'food',
            'restaurant_id'     => $restaurant_id,
            'pin_code'          => $pin_code,
            'customer_name'     => $name,
            'customer_phone'    => $phone,
            'pickup'            => $data['restaurant_name'],
            'destination'       => $data['address'],
            'pickup_lat'        => $data['restaurantLat'],
            'pickup_lng'        => $data['restaurantLng'],
            'destination_lat'   => $data['destination_lat'],
            'destination_lng'   => $data['destination_lng'],
            'destination_lng'   => $data['destination_lng'],
            'destination_address'   => $data['destination_address'],            
            'distance'          => $data['distance'],
            'address'           => $data['address'],
            'duration'          => $data['duration'],
            'tarif'             => $data['tarif'],
            'payment_metode'    => $data['payment_method'] ?? 'Tunai',
            'shipping_cost'     => $data['shipping_cost'] ?? 0,
            'app_fee'           => $data['app_fee'] ?? 0,
            'total_amount'      => $data['total_amount'] ?? 0,
            'order_status'      => 'new',
            'created_at'        => date('Y-m-d H:i:s'),
        ]);

        // =============================
        // 🔥 Simpan items
        // =============================
        foreach ($data['items'] as $item) {
            $orderItemModel->insert([
                'order_id'  => $insertID,
                'menu_id'   => $item['id'],
                'menu_name' => $item['name'],
                'price'     => $item['price'],
                'qty'       => $item['qty'],
                'note'      => $item['note'] ?? null,
            ]);

            // kurangi stok
            // $menuModel->set('stock', 'stock - ' . (int) $item['qty'], false)
            //     ->where('id', $item['id'])
            //     ->update();
        }

        $db->transComplete();

        if ($db->transStatus() === false) {
            return $this->response->setJSON([
                'status'    => 'error',
                'message'   => 'Gagal menyimpan pesanan!'
            ]);
        }

    
        // =============================
        // 🔥 Kirim ke WebSocket API
        // =============================
        $this->postToWebSocketApi("/api/order/new", [
            'order_id'          => $OrderID,
            'order_type'        => 'food',
            'restaurant_id'     => $restaurant_id,
            'pin_code'          => $pin_code,
            'customer_name'     => $name,
            'customer_phone'    => $phone,
            'pickup'            => $data['restaurant_name'],
            'destination'       => $data['address'],
            'pickup_lat'        => $data['restaurantLat'],
            'pickup_lng'        => $data['restaurantLng'],
            'destination_lat'   => $data['destination_lat'],
            'destination_lng'   => $data['destination_lng'],
            'destination_address'   => $data['destination_address'],
            'distance'          => $data['distance'],
            'address'           => $data['address'],
            'duration'          => $data['duration'],
            'tarif'             => $data['tarif'],
            'payment_metode'    => $data['payment_method'] ?? 'Tunai',
            'shipping_cost'     => $data['shipping_cost'] ?? 0,
            'app_fee'           => $data['app_fee'] ?? 0,
            'total_amount'      => $data['total_amount'] ?? 0,
            'order_status'      => 'new',
            'created_at'        => date('Y-m-d H:i:s'),
            // 'created_at'        => $data('created_at'),
            
        ]);



        return $this->response->setJSON([
            'status'    => 'success',
            'message'   => 'Pesanan berhasil disimpan!',
            'order_id'  => $OrderID   // ✔ ini benar!
        ]);
    }



    private function generateOrderId()
    {        

        // Ambil order terakhir berdasarkan ID paling besar
        $lastOrder = $this->orderModel->orderBy('id', 'DESC')->first();

        // Jika belum ada order sama sekali
        if (!$lastOrder || empty($lastOrder['order_id'])) {
            return "F-0000001";
        }

        $lastOrderId = $lastOrder['order_id'];

        // Ambil hanya angka di belakang, abaikan prefix apa pun
        preg_match('/(\d+)$/', $lastOrderId, $match);

        // Jika tidak ada angka di belakang (error case)
        if (!isset($match[1])) {
            return "F-0000001";
        }

        $lastNumber = (int)$match[1];   // ubah ke integer
        $newNumber = $lastNumber + 1;   // naikkan nomor

        // Buat format baru: F-000000X
        return "F-" . str_pad($newNumber, 7, "0", STR_PAD_LEFT);
    }
}
