<?php

namespace App\Controllers;

use App\Models\OrderModel;
use App\Models\UlasanModel;

class HistoryController extends BaseController
{

    public function alfaride()
    {
        $order_id = $this->request->getGet('order_id');
        $order = null;
        echo $order_id;
        die;

        if ($order_id) {
            $orderModel = new OrderModel();
            $order = $orderModel->getOrderById($order_id);
            // 🧪 Tambahkan debug untuk memastikan datanya ada
            // echo "<pre>"; print_r($order_id); die;
        }

        return view('customer/alfaride', [
            'data' => $order
        ]);
    }



    public function alfafood()
    {
        return view('restaurants/list');
    }


    public function index0()
    {
        $this->token = $this->request->getGet('token');
        $this->phone = $this->request->getGet('customer_phone');

        $orderModel = new OrderModel();
        $orders = $orderModel->getAllOrders();

        return view('order/index', ['orders' => $orders]);
    }

    public function index1()
    {


        $orderModel = new OrderModel();
        $reviewModel = new UlasanModel();

        // 🔹 Ambil semua order berdasarkan nomor HP
        $orders = $orderModel->getAllOrdersByPhone($this->phone);

        // 🔹 Tandai mana yang sudah direview
        foreach ($orders as &$order) {
            $review = $reviewModel->where('order_id', $order['order_id'])->first();
            $order['reviewed'] = !empty($review);
        }

        dd($orders);
        // 🔹 Kirim ke view
        return view('history', [
            'orders' => $orders,
            // 'pendingCount' => $pendingCount
        ]);
    }

    public function index($role = 'customer')
    {
        $orderModel  = new OrderModel();
        $reviewModel = new UlasanModel();

        // ==============================
        // TIPE ROLE: customer / driver / restaurant
        // ==============================
        switch ($role) {

            case 'driver':
                // History driver berdasarkan nomor HP driver
                $phone = $this->phone; // atau session('phone')
                $orders = $orderModel->getAllOrdersByDriverPhone($phone);
                $view = 'history_driver';
                break;

            case 'restaurant':
                // Semua order milik restoran tertentu
                $restaurantId = session('restaurant_id');
                $orders = $orderModel->getOrders($this->restaurantId);
                $view = 'restaurants/order';
                break;

            default: // customer
                // Semua order customer berdasarkan nomor HP
                $phone = $this->phone;
                $orders = $orderModel->getAllOrdersByPhone($phone);
                $view = 'history';
                break;
        }

        // ==============================
        // Tambahkan informasi apakah sudah direview (untuk customer)
        // ==============================
        if ($role === 'customer') {
            foreach ($orders as &$order) {
                $review = $reviewModel
                    ->where('order_id', $order['order_id'])
                    ->first();

                $order['reviewed'] = !empty($review);
            }
        }
     
        // ==============================
        // Kirim ke view
        // ==============================
        return view($view, [
            'orders' => $orders
        ]);
    }


    // public function detail($id)
    // {
    //     $orderModel = new OrderModel();
    //     $order = $orderModel->getOrderById($id);

    //     if (!$order) {
    //         throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound('Order tidak ditemukan');
    //     }

    //     return view('order/detail', ['order' => $order]);
    // }
}
