<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\OrderModel;
use App\Models\UlasanModel;
use App\Models\RiwayatDriverModel;

helper('format');


class Driver extends BaseController
{
    public function index()
    {

    //    dd($this->wsURL);
        $user = $this->userModel
            ->where('phone', $this->phone)
            ->first();

        $order_id = $user['order_id'] ?? null;

        $order = null;
        if ($order_id) {
            if (str_starts_with(strtoupper($order_id), 'R')) {
                // 🔵 Order Ride                
                $result = $this->orderModel->getOrderById($order_id);
                $order = !empty($result) ? $result : null;
            } elseif (str_starts_with(strtoupper($order_id), 'F')) {
                // 🟠 Order Food
                $result = $this->orderModel->getOrders(null, $order_id);
                $order = !empty($result) ? $result[0] : null;
            }
        }


        // dd($this->phone);

        $model = new RiwayatDriverModel();
        $riwayat = $model->getRiwayat($this->phone);

        return view('driver', [
            'user'  => $user,
            'order' => $order, // ← bisa null
            'riwayat_driver' => [
                'total_pendapatan' => $riwayat['total_pendapatan'] ?? 0,
                'total_order'      => $riwayat['total_order'] ?? 0
            ]
        ]);
    }

    public function alfaride()
    {
        return view('customer/alfaride');
    }

    public function alfafood()
    {
        return view('restaurants/list');
    }

    public function Order()
    {
        $this->phone = session()->get('phone');
        $order_status = session()->get('order_status');
        $order_id = session()->get('order_id');

        $orderModel = new OrderModel();
        $order = $orderModel->getOrderById($order_id);

        if (!$order) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound('Order tidak ditemukan');
        }

        // redirect() view('driver', ['order_id' => $order_id,'order_status' => $order_status]);
        return redirect()->to('/driver');
    }

    public function review()
    {

        $order_id = $this->request->getGet('order');

        $orderModel = new OrderModel();
        $order = $orderModel->getOrderById($order_id);

        if (!$order) {
            throw new \CodeIgniter\Exceptions\PageNotFoundException('Order tidak ditemukan');
        }

        $reviewModel = new UlasanModel();
        // 🔍 Cek apakah sudah ada ulasan untuk order ini
        $existingReview = $reviewModel->where('order_id', $order_id)->first();

        // kirim flag untuk view
        $isCancelled = ($order['order_status'] === 'cancelled');

        return view('review_driver', [
            'driver_name' => $order['driver_name'] ?? 'Driver',
            'driver_phone' => $order['driver_phone'],
            'order_id' => $order['order_id'],
            'pickup' => $order['pickup'],
            'destination' => $order['destination'],
            'created_at' => $order['created_at'],
            'review' => $existingReview, // ✅ kirim review ke view
            'isCancelled' => $isCancelled
        ]);
    }

    public function submitReview()
    {
        $rating = $this->request->getPost('rating');
        $ulasan = $this->request->getPost('ulasan');
        $driver_phone = $this->request->getPost('driver_phone');
        $order_id = $this->request->getPost('order_id');

        // 🔹 Validasi data wajib
        if (!$rating || !$driver_phone || !$order_id) {
            return redirect()->back()->with('error', 'Data tidak lengkap untuk mengirim ulasan.');
        }

        $orderModel = new OrderModel();
        $order = $orderModel->getOrderById($order_id);

        if (!$order) {
            return redirect()->back()->with('error', 'Order tidak ditemukan.');
        }

        // 🔹 Jika status order dibatalkan, tolak review
        if ($order['order_status'] === 'cancelled') {
            return redirect()->back()->with('error', 'Order dibatalkan — ulasan tidak dapat dikirim.');
        }

        $customer_phone = $order['customer_phone'];
        $db = db_connect();

        // 🔹 Cegah duplikasi review
        $existing = $db->table('ulasan_driver')
            ->where('order_id', $order_id)
            ->countAllResults();

        if ($existing > 0) {
            return redirect()->back()->with('error', 'Order ini sudah diberi ulasan sebelumnya.');
        }

        // 🔹 Simpan ulasan baru
        $db->table('ulasan_driver')->insert([
            'driver_phone' => $driver_phone,
            'order_id' => $order_id,
            'rating' => $rating,
            'ulasan' => $ulasan,
            'created_at' => date('Y-m-d H:i:s')
        ]);

        // 🔹 Redirect kembali ke history
        return redirect()
            ->to(base_url('history?customer_phone=' . urlencode($customer_phone)))
            ->with('message', '✅ Ulasan berhasil dikirim. Terima kasih atas feedback Anda!');
    }
    public function ToggleRide()
    {

        if (!$this->userData) {
            return $this->response->setJSON(['success' => false, 'message' => 'Data user tidak di temukan']);
        }

        $newStatus = $this->userData['driver_ride'] == 1 ? 0 : 1;

        $this->userModel->update($this->phone, ['driver_ride' => $newStatus]);

        return $this->response->setJSON([
            'success' => true,
            'newStatus' => $newStatus
        ]);
    }
    public function ToggleFood()
    {
        if (!$this->userData) {
            return $this->response->setJSON(['success' => false, 'message' => 'Data user tidak di temukan']);
        }

        $newStatus = $this->userData['driver_ride'] == 1 ? 0 : 1;

        $newStatus = $this->userData['driver_food'] == 1 ? 0 : 1;

        $this->userModel->update($this->phone, ['driver_food' => $newStatus]);

        return $this->response->setJSON([
            'success' => true,
            'newStatus' => $newStatus
        ]);
    }
    public function ToggleAutoBid()
    {
        if (!$this->userData) {
            return $this->response->setJSON(['success' => false, 'message' => 'Data user tidak di temukan']);
        }

        $newStatus = $this->userData['driver_ride'] == 1 ? 0 : 1;

        $newStatus = $this->userData['auto_bid_driver'] == 1 ? 0 : 1;

        $this->userModel->update($this->phone, ['auto_bid_driver' => $newStatus]);

        return $this->response->setJSON([
            'success' => true,
            'newStatus' => $newStatus
        ]);
    }
}
