<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\RestaurantModel;

class Dashboard extends BaseController
{
    public function index()
    {
        $this->phone = session()->get('phone'); // ambil user dari session
        $userModel = new UserModel();
        $user = $userModel->where('phone', $this->phone)->first();

        if (!$user) {
            return redirect()->to('/login');
        }

        $role = $user['role'] ?? '';

        // cek role
        // if (empty($role)) {
        //     // role kosong → tampilkan halaman dashboard pilih role
        //     return view('dashboard', ['user' => $user]);
        // }

        // redirect sesuai role
        return redirect()->to('/' . $role);
    }


    public function setRole()
    {
        $role = $this->request->getPost('role');

        if ($role === 'driver') {
            if ($this->userData['driver'] === 'N') {
                return $this->response->setJSON([
                    'status' => false,
                    'message' => 'Anda belum terdaftar sebagai mitra driver'
                ]);
            }
        }

        if ($role === 'restaurant') {
            if ($this->userData['restaurant'] === 'N') {
                // return redirect()->to('/restaurants/register');
                return $this->response->setJSON([
                    'status' => false,
                    'message' => 'Anda belum terdaftar sebagai mitra toko',
                ]);
            }
            $restaurantModel = new RestaurantModel();
            $restaurant = $restaurantModel->getRestaurantByUserPhone($this->phone);

            if (!$restaurant) {
                return $this->response->setJSON([
                    'status' => false,
                    'message' => 'Anda belum mendaftarkan restoran',
                    'redirect' => '/alfafood/register'
                ]);
            } else {
                $active = $restaurant['active'];
                if ($this->userData['restaurant'] === 'Y' && $active == 0) {
                    return $this->response->setJSON([
                        'status' => false,
                        'message' => 'Restoran belum aktif',
                        'redirect' => '/alfafood/register/success'
                    ]);
                }
            }
        }


        // update role berdasarkan ID (primary key)
        $this->userModel->update($this->phone, [
            'role' => $role
        ]);

        // tentukan redirect sesuai role
        $redirectUrl = match ($role) {
            'customer' => '/customer',
            'driver' => '/driver',
            'restaurant' => '/restaurant',
            default => '/role'
        };

        return $this->response->setJSON([
            'status' => true,
            'role' => $role,
            'message' => 'Role berhasil dipilih',
            'redirect' => $redirectUrl
        ]);
    }

    public function Role()
    {
        // $this->phone = session()->get('phone'); // ini string nomor hp
        // $userModel = new UserModel();
        // $user = $userModel->where('phone', $this->phone)->first();
        // $role = $user['role'];

        // if (!$user) {
        //     return $this->response->setJSON([
        //         'status' => false,
        //         'message' => 'Data user tidak ditemukan'
        //     ]);
        // }


        // if ($role == "customer") {
        //     return view('customer/alfafood');
        // } else if ($role == "driver") {
        //     return view('driver');
        // } else if ($role == "toko") {
        //     return view('toko');
        // } else {
        //     return view('dashboard');
        // }

        return view('dashboard');
    }
}
