<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use App\Models\UserModel;
use App\Models\RestaurantModel;
use App\Models\MenuModel;
use App\Models\OrderModel;
use App\Libraries\WebSocketClient;

abstract class BaseController extends Controller
{
    protected $userModel;
    protected $restaurantModel;
    protected $menuModel;
    protected $orderModel;
    protected $userData;
    protected $token;
    protected $phone;
    protected $role;
    protected $restaurantId;
    protected $baseUrl;
    protected $ws;
    protected $userDataSesion;
    protected string $wsURL;
    protected string $wsPORT;
    protected string $wsAuthKey;

    public function initController(...$params)
    {
        parent::initController(...$params);

        $this->userModel = new UserModel();
        $this->restaurantModel = new RestaurantModel();
        $this->menuModel = new MenuModel();
        $this->orderModel = new OrderModel();

        // ===============================
        // BUILD WS URL FROM ENV
        // ===============================

        $this->baseUrl = rtrim(env('app.baseURL'), '/');

        $this->wsURL = rtrim(env('WS_URL'), '/');

        $this->wsAuthKey = env('WS_AUTH_KEY');

        $this->wsPORT = env('WS_PORT');
        
      
        // 🔥 Inisialisasi WebSocket Client (GLOBAL)
        $this->ws = new WebSocketClient();

        // Ambil user dari session (filter sudah pastikan token valid)
        if (session()->has('user')) {
            $this->userDataSesion     = session('user');
            // dd($this->userDataSesion);
            $this->token    = $this->userDataSesion['token'] ?? null;
            $this->phone    = $this->userDataSesion['phone'] ?? null;


            $this->userData = $this->userModel
                ->where('token', $this->token)
                ->where('phone', $this->phone)
                ->first();


            // dd($this->userData);
            // if (!$this->userData) {
            //     redirect()->to('/login')->send();
            //     exit; // 🔥 WAJIB
            // }


            $this->role     = $data['role'] ?? null;
            $this->restaurantId     = $data['restaurant_id'] ?? null;
        }
    }

    public function sendToWebSocket($payload, $api_url)
    {
        try {

            $wsUrl = $this->wsURL . "/{$api_url}";

            $client = new \WebSocket\Client($wsUrl);

            $client->text(json_encode($payload));
            $client->close();
        } catch (\Exception $e) {

            log_message('error', 'WebSocket Error: ' . $e->getMessage());
        }
    }
    public function postToWebSocketApi($endpoint, $payload = [])
    {


        $url =  $this->baseUrl . ':' . $this->wsPORT . $endpoint;
        log_message('debug', $url);
        // log_message('payload', json_encode($payload) );

        $client = \Config\Services::curlrequest([
            'timeout' => 5,
            'http_errors' => false
        ]);

        try {

            $response = $client->post($url, [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'X-API-KEY' => $this->wsAuthKey // opsional (lebih aman)
                ],
                'body' => json_encode($payload)
            ]);

            return json_decode($response->getBody(), true);
        } catch (\Exception $e) {
            log_message('error', 'POST WebSocket API Error: ' . $e->getMessage());
            return false;
        }
    }
}
