<?php

namespace App\Controllers;

use App\Controllers\BaseController;

use App\Models\OtpModel;
use Faker\Provider\PhoneNumber;

class Auth extends BaseController
{
    public function login0()
    {

        if ($this->role === 'customer') {
            // return redirect()->to('/restaurant')->with('message', 'Kode OTP telah dikirim ke nomor Anda');

            return redirect()->to("/alfafood");
        } else  if ($this->role === 'driver') {
            // return redirect()->to('/restaurant')->with('message', 'Kode OTP telah dikirim ke nomor Anda');

            return redirect()->to("/driver");
        } else  if ($this->role === 'restaurant') {
            // return redirect()->to('/restaurant')->with('message', 'Kode OTP telah dikirim ke nomor Anda');

            return redirect()->to("/restaurant");
        }
        // return view('auth/login');
        return view('auth/login');
    }

    public function login()
    {
        // Cek session     
        $token = $this->token;

        if ($token) {

            // Cek database         
            $user = $this->userModel->where('token', $token)->first();

            if ($user) {

                // Token valid → redirect sesuai role
                if ($user['role'] === 'customer') {
                    return redirect()->to('/alfafood');
                }

                if ($user['role'] === 'driver') {
                    return redirect()->to('/driver');
                }

                if ($user['role'] === 'restaurant') {
                    return redirect()->to('/restaurant');
                }
            }
        }

        // Tidak ada token atau token invalid → tampilkan login
        return view('auth/login');
    }


    public function loginPost()
    {
        $phone = $this->request->getPost('phone');


        if (!$phone) {
            return redirect()->back()->with('error', 'Nomor HP wajib diisi');
        }
        $token = bin2hex(random_bytes(32));

        // Set session sekali
        session()->set('user', [
            'phone' => $phone,
            'token' => $token,   // SIMPAN token
        ]);

 

        $otpController = new OtpController();

        // Tangkap hasil pengiriman OTP
        $result = $otpController->sendOtp($phone);

        // sendOtp() harus mengembalikan array/JSON status
        if ($result['status'] === true) {
            return redirect()
                ->to('/auth/otp')
                ->with('phone', $phone)
                ->with('token', $token)
                ->with('message', 'Kode OTP telah dikirim ke nomor Anda');
        } else {
            return redirect()->back()->with('error', $result['message']);
        }

        // return redirect()->to('/otp')->with('message', 'OTP telah dikirim ke nomor HP Anda');
    }


    public function otp()
    {
        $phone = session()->getFlashdata('phone');

        if (!$phone) {
            return redirect()->to('/login');
        }

        return view('otp', ['phone' => $phone]);
    }


    public function logout()
    {
        // Ambil user dari token global
        $user = $this->userModel->where('token', $this->token)->first();

        if ($user) {
            // Reset data user di database
            $this->userModel->update(
                $user['phone'],
                [
                    'token' => "",
                    'login' => 'N'
                ]
            );
        }

        // HAPUS SESSION
        session()->destroy();
        session()->remove('user');

        return $this->response->setJSON([
            'status'   => true,
            'message'  => 'Logout berhasil',
            'redirect' => base_url('/login')
        ]);
    }

    public function UpdateFCM()
    {
        $fcm_token = $this->request->getVar('fcm_token');
        $phone_ = $this->request->getVar('phone');

        if (!$phone_ || !$fcm_token) {
            return $this->response->setJSON([
                'status' => false,
                'message' => "❌ Nomor telepon dan token FCM wajib dikirim. token={$fcm_token}, phone={$phone_}"
            ]);
        }


        $user = $this->userModel->where('phone', $phone_)->first();

        if (!$user) {
            return $this->response->setJSON([
                'status' => false,
                'message' => '⚠️ Pengguna dengan nomor tersebut tidak ditemukan.'
            ]);
        }

        // ✅ Pastikan field fcm_token termasuk dalam allowedFields
        $this->userModel->where('phone', $phone_)
            ->set(['fcm_token' => $fcm_token])
            ->update();

        // Jangan hanya andalkan affectedRows, karena bisa 0 jika nilai sama
        return $this->response->setJSON([
            'status' => true,
            'message' => '✅ Token FCM berhasil diperbarui.'
        ]);
    }


    public function verifyOtp()
    {
        $otpInput = $this->request->getPost('otp');


        $otpModel = new OtpModel();
        $otpData = $otpModel
            ->where('phone',  $this->phone)
            ->where('otp', $otpInput)
            ->orderBy('id', 'DESC')
            ->first();

        if (!$otpData) {
            return $this->response->setJSON([
                'error' => 'error',
                'message'  => "Kode OTP salah, silakan coba lagi.",
                'redirect' => base_url('/otp')
            ]);
        }

        // ✅ Cek expired
        if (date('Y-m-d H:i:s') > $otpData['expired']) {
            return $this->response->setJSON([
                'error' => 'error',
                'message' => 'Kode OTP sudah kadaluarsa.',
                'redirect' => base_url('/otp')
            ]);
        }

        $otpModel->where('phone',  $this->phone)
            ->where('otp', $otpInput)
            ->delete();

        // $this->token = bin2hex(random_bytes(32));

        $user = $this->userModel->where('phone', $this->phone)->first();

        if ($user) {
            $this->userModel->update($this->phone, [
                'token' => $this->token,
                'login' => 'Y',
                'role' => '',
                'first_login' => date('Y-m-d H:i:s')
            ]);

            return $this->response->setJSON([
                'status' => true,
                'message' => 'Login berhasil',
                'token' => $this->token,
                'phone' =>  $this->phone,
                'name' => $user['nama'],
                'role' => $user['role']
            ]);
        } else {
            return $this->response->setJSON([
                'status' => true,
                'message' => 'Silakan daftar dulu',
                'token' => $this->token,
                'phone' => $this->phone,
                'redirect' => base_url('/register')
            ]);
        }
    }

    public function registerPost()
    {
        // if ($redirect = checkIfLoggedIn())
        //     return $redirect;

        // if ($redirect = checkIfAdministrator())
        //     return $redirect;
        // $validation = \Config\Services::validation();

        // $rules = [
        //     'nrp' => [
        //         'label' => 'NRP',
        //         'rules' => 'required|regex_match[/^[0-9]{8}$/]|is_unique[users.nrp]',
        //     ],
        //     'name' => [
        //         'label' => 'Nama',
        //         'rules' => 'required|min_length[4]',
        //     ],
        //     'password' => [
        //         'label' => 'Password',
        //         'rules' => 'required|min_length[8]|regex_match[/(?=.*[a-z])(?=.*[A-Z])(?=.*\d).{8,}/]',
        //     ],
        //     'pangkat' => [
        //         'label' => 'Pangkat',
        //         'rules' => 'required',
        //     ],
        //     'no_hp' => [
        //         'label' => 'No HP',
        //         'rules' => 'required|numeric|min_length[10]|is_unique[users.no_hp]',
        //     ],
        // ];

        // $messages = [
        //     'nrp' => [
        //         'required' => 'NRP wajib diisi.',
        //         'regex_match' => 'NRP harus terdiri dari tepat 8 angka.',
        //         'is_unique' => 'NRP sudah terdaftar.',
        //     ],
        //     'name' => [
        //         'required' => 'Nama wajib diisi.',
        //         'min_length' => 'Nama minimal 4 karakter.',
        //     ],
        //     'password' => [
        //         'required' => 'Password wajib diisi.',
        //         'min_length' => 'Password minimal 8 karakter.',
        //         'regex_match' => 'Password harus mengandung huruf besar, huruf kecil, dan angka.',
        //     ],
        //     'pangkat' => [
        //         'required' => 'Pangkat wajib dipilih.',
        //     ],
        //     'no_hp' => [
        //         'required' => 'No HP wajib diisi.',
        //         'numeric' => 'No HP hanya boleh angka.',
        //         'min_length' => 'No HP minimal 10 angka.',
        //         'is_unique' => 'No HP sudah terdaftar.',
        //     ],
        // ];


        // if (!$this->validate($rules, $messages)) {
        //     return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        // }

        $name = $this->request->getPost('name');

        if (empty($name)) {
            return redirect()->back()->with('error', 'Nama tidak boleh kosong.');
        }

        if (is_array($name)) {
            $name = implode(' ', $name); // gabungkan jika array
        }

        $this->userModel->insert([
            'phone' => $this->phone,
            'nama'  => strtoupper($name),
            'token' => $this->token,
            'login' => 'Y'
        ]);

        // return redirect()->to('/role')->with('message', 'Registrasi berhasil! Silakan login.');
        // return redirect()->to('/logout')->with('message', 'Registrasi berhasil! Silakan login.');
        // return redirect()->back()->withInput()->with('success', 'Registrasi berhasil!');

        // return $this->response->setJSON([
        //     'success' => 'success',
        //     'phone' => session()->get('phone'),
        //     'nama' => strtoupper($name),
        //     'token' => session()->get('token'),
        //     'message' => 'Registrasi berhasil!',
        //     'redirect' => base_url('/dashboard')
        // ]);

        $user = $this->userModel->where('token', $this->token)->first();

        if ($user) {
            // Reset data user di database
            $this->userModel->update(
                $user['phone'],
                [
                    'token' => "",
                    'login' => 'N'
                ]
            );
        }

        // HAPUS SESSION
        // session()->destroy();
        session()->remove('user');

        return redirect()->to('/login')->with('info', 'Registrasi berhasil! Silakan login kembali.');
    }
}
