<?php

namespace App\Controllers;

use CodeIgniter\Controller;
// use App\Models\RestaurantModel;
// use App\Models\UlasanModel;
// use App\Models\UserModel;
// use App\Models\MenuModel;

class AlfaFood extends BaseController
{
    public function index()
    {

        return view('alfafood/list'); // view-nya yang kamu tulis di atas
    }

    public function getAll0()
    {

        $search = $this->request->getGet('search');
        $userLat = $this->request->getGet('lat');
        $userLon = $this->request->getGet('lng');

        // 🔥 Hanya restoran yang aktif
        $this->restaurantModel->where('active', 1);
        // Filter name / description
        if ($search) {
            $searchLower = strtolower($search);
            $this->restaurantModel
                ->groupStart()
                ->like('LOWER(name)', $searchLower)
                ->orLike('LOWER(description)', $searchLower)
                ->groupEnd();
        }

        // Jika lat/lon ada → hitung jarak (Haversine)
        if ($userLat && $userLon) {

            $haversine = "
            (6371 * acos(
                cos(radians($userLat)) 
                * cos(radians(loc_lat)) 
                * cos(radians(loc_lng) - radians($userLon)) 
                + sin(radians($userLat)) 
                * sin(radians(loc_lat))
            )) AS distance
        ";

            $this->restaurantModel->select("restaurants.*, $haversine");

            // 🔥 PRIORITAS SORT:
            // 1. open = Y dulu
            // 2. baru sort berdasarkan jarak
            $this->restaurantModel->orderBy("CASE WHEN open = '1' THEN 1 ELSE 2 END", "ASC");
            $this->restaurantModel->orderBy("distance", "ASC");
        } else {
            // default sort jika tanpa lokasi
            $this->restaurantModel->orderBy("CASE WHEN open = '1' THEN 1 ELSE 2 END", "ASC");
            $this->restaurantModel->orderBy("name", "ASC");
        }

        $restaurants =   $this->restaurantModel->findAll();

        return $this->response->setJSON([
            'status' => true,
            'data' => $restaurants
        ]);
    }

    public function getAll()
    {
        $search  = $this->request->getGet('search');
        $userLat = $this->request->getGet('lat');
        $userLon = $this->request->getGet('lng');

        $builder = $this->restaurantModel;

        // 🔥 hanya restoran aktif
        $builder->where('active', 1);

        // 🔎 search
        if ($search) {
            $searchLower = strtolower($search);
            $builder->groupStart()
                ->like('LOWER(name)', $searchLower)
                ->orLike('LOWER(description)', $searchLower)
                ->groupEnd();
        }

        // ============================
        // 📍 SORT PALING DEKAT
        // ============================
        if ($userLat && $userLon) {

            $haversine = "
        (6371 * acos(
            cos(radians($userLat))
            * cos(radians(loc_lat))
            * cos(radians(loc_lng) - radians($userLon))
            + sin(radians($userLat))
            * sin(radians(loc_lat))
        ))
    ";

            $builder->select("
        restaurants.*,
        IF(loc_lat IS NULL OR loc_lng IS NULL, NULL, $haversine) AS distance
    ");

            // 🔥 URUTAN FINAL
            $builder->orderBy("CASE WHEN open = '1' THEN 0 ELSE 1 END", "ASC");
            $builder->orderBy("CASE WHEN distance IS NULL THEN 1 ELSE 0 END", "ASC");
            $builder->orderBy("distance", "ASC");
        }


        $restaurants = $builder->findAll();

        return $this->response->setJSON([
            'status' => true,
            'data'   => $restaurants
        ]);
    }

    public function checkout()
    {
        return view('alfafood/checkout');
    }

    public function getById($id)
    {

        $data =   $this->restaurantModel->find($id);

        if (!$data) {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'Restaurant tidak ditemukan'
            ]);
        }

        return $this->response->setJSON([
            'status' => true,
            'data' => $data
        ]);
    }
    public function Dashboard()
    {
        return view('restaurants/restaurant_dashboard');
    }
    public function register()
    {

        $dataRestaurant = $this->restaurantModel->find($this->restaurantId);

        if ($this->restaurantId != null) {
            if ($dataRestaurant && $dataRestaurant['active'] == 0) {
                return redirect()->to('/alfafood/register/success');
            }

            if ($dataRestaurant && $dataRestaurant['active'] == 1) {
                return redirect()->to('/restaurant');
            }
        }
        return view('restaurants/register', [
            'user'     => $this->userData,
        ]);
        // return view('restaurants/register');
    }
    public function RegisterSuccess()
    {
        return view('restaurants/register_success');
    }

    public function postRegister()
    {


        // ===== Validasi field wajib =====
        $requiredFields = ['resto_name', 'category', 'description', 'address', 'email'];
        foreach ($requiredFields as $field) {
            if (empty($this->request->getPost($field))) {
                return $this->response->setJSON([
                    'success' => false,
                    'msg' => "Field '$field' wajib diisi!"
                ]);
            }
        }

        // ===== Cek Email Unik =====
        $email = $this->request->getPost('email');
        if ($this->restaurantModel->where('email', $email)->first()) {
            return $this->response->setJSON([
                'success' => false,
                'msg' => "Email sudah terdaftar!"
            ]);
        }

        // ==========================================
        //  HANDLING SEMUA FILE UPLOAD (dinamis)
        // ==========================================
        $uploadedFiles = $this->request->getFiles();
        $fileResults = []; // hasil upload

        foreach ($uploadedFiles as $inputName => $fileObject) {

            if ($fileObject->isValid() && !$fileObject->hasMoved()) {

                $folder = '';

                // Tentukan folder berdasarkan nama input
                switch ($inputName) {
                    case 'imageKTP':
                        $folder = 'uploads/ktp';
                        break;

                    case 'logo':
                        $folder = 'uploads/logo';
                        break;

                    default:
                        $folder = 'uploads/others';
                        break;
                }

                try {
                    $newName = $fileObject->getRandomName();
                    $fileObject->move(FCPATH . $folder, $newName);
                    $fileResults[$inputName] = '/' . $folder . '/' . $newName;
                } catch (\Exception $e) {
                    return $this->response->setJSON([
                        'success' => false,
                        'msg' => "Upload file '$inputName' gagal: " . $e->getMessage()
                    ]);
                }
            }
        }

        // ==========================================
        //  SIMPAN DATA RESTORAN
        // ==========================================
        $dataRestaurant = [
            'name'        => $this->request->getPost('resto_name'),
            'category'    => $this->request->getPost('category'),
            'description' => $this->request->getPost('description'),
            'address'     => $this->request->getPost('address_restaurant'),
            'loc_lat'     => $this->request->getPost('loc_lat'),
            'loc_lng'     => $this->request->getPost('loc_lng'),
            'email'       => $email,
            'logo_url'    => $fileResults['logo'] ?? null,
            'status'      => 'pending'
        ];

        try {
            $this->restaurantModel->insert($dataRestaurant);
            $restaurantId = $this->restaurantModel->insertID();

            if (!$restaurantId) {
                return $this->response->setJSON([
                    'success' => false,
                    'msg' => "Gagal mendapatkan ID restoran."
                ]);
            }

            // ==========================================
            //  UPDATE DATA USER
            // ==========================================
            $userUpdate = [
                'alamat'        => $this->request->getPost('address'),
                'restaurant'    => 'Y',
                'restaurant_id' => $restaurantId,
                'nik'           => $this->request->getPost('nik')
            ];

            if (!empty($fileResults['imageKTP'])) {
                $userUpdate['nik_url'] = $fileResults['imageKTP'];
            }

            $this->userModel->update($this->phone, $userUpdate);

            return $this->response->setJSON([
                'success' => true,
                'msg' => 'Restoran berhasil didaftarkan!',
                'redirect' => '/alfafood/register/success'
            ]);
        } catch (\Exception $e) {

            return $this->response->setJSON([
                'success' => false,
                'msg' => "Error: " . $e->getMessage()
            ]);
        }
    }

    public function menus($restaurant_id)
    {

        $restaurant = $this->restaurantModel->find($restaurant_id);
        if (!$restaurant) {
            return redirect()->to('/alfafood')->with('error', 'Restoran tidak ditemukan.');
        }

        if ($restaurant["open"] == "0") {
            return redirect()->to('/alfafood');
        }

        $menus = $this->menuModel
            ->where('restaurant_id', $restaurant_id)
            ->orderBy("CASE WHEN available = '1' THEN 0 ELSE 1 END", "ASC")
            ->orderBy("name", "ASC")
            ->findAll();

        return view('alfafood/menu_list', [
            'restaurant' => $restaurant,
            'menus' => $menus
        ]);
    }
    // API endpoint untuk ambil menu via AJAX
    public function getMenus($restaurant_id)
    {

        $menus = $this->menuModel->where('restaurant_id', $restaurant_id)->findAll();

        return $this->response->setJSON([
            'status' => true,
            'data' => $menus
        ]);
    }
}
