<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

$routes->group('/', ['filter' => 'auth'], function ($routes) {
     
});

$routes->GET('/', 'Home::index');
$routes->GET('/login', 'Auth::login');
$routes->GET('/auth/otp', 'Auth::otp');

$routes->POST('/login', 'Auth::loginPOST');
$routes->POST('/auth/verifyOtp', 'Auth::verifyOtp');
$routes->POST('/auth/otp/resend', 'OtpController::resendOtp');
$routes->POST('/auth/otp/send', 'OtpController::sendOtp');
$routes->POST('/auth/registerPOST', 'Auth::registerPOST');
$routes->GET('/role', 'Dashboard::Role');
$routes->POST('/setRole', 'Dashboard::setRole');





$routes->GET('/driver', 'Driver::Index');
$routes->GET('/register', 'Home::register');
$routes->GET('/alfaride', 'Customer::alfaride');
$routes->GET('/driver/review', 'Driver::review');
$routes->POST('/driver/submitReview', 'Driver::submitReview');

$routes->GET('/profile', 'ProfileController::index');
$routes->GET('/customer', 'Customer::menu');

// $routes->GET('/history', 'HistoryController::index');
$routes->POST('/logout', 'Auth::Logout');
$routes->POST('/user/fcm', 'Auth::UpdateFCM');

$routes->GET('/topup', 'TopupController::index');
$routes->POST('/topup/payment', 'TopupController::payment');

$routes->GET('/restaurants', 'Restaurant::index');
$routes->GET('/restaurants/dashboard', 'Restaurant::Dashboard');


$routes->GET('/history', 'HistoryController::index/customer');
$routes->GET('/history-driver', 'HistoryController::index/driver');
// $routes->GET('/restaurant/orders', 'HistoryController::index/restaurant');




// ALFAFOOD
$routes->GET('/alfafood', 'AlfaFood::index');
$routes->GET('/alfafood/register', 'AlfaFood::register');
$routes->POST('/alfafood/register/save', 'AlfaFood::POSTRegister');
$routes->GET('/alfafood/register/success', 'AlfaFood::RegisterSuccess');
$routes->GET('/alfafood/(:num)/menus', 'AlfaFood::menus/$1');
$routes->GET('/api/alfafood/restaurants', 'AlfaFood::GETAll');
$routes->GET('/api/alfafood/restaurants/(:num)', 'AlfaFood::GETById/$1');
$routes->GET('/alfafood/checkout', 'AlfaFood::checkout');


// RESTAURANTS
$routes->GET('/restaurant', 'Restaurant::index');
// $routes->GET('/restaurant_order', 'Restaurant::Order');
$routes->GET('/restaurant_order', 'HistoryController::index/restaurant');
$routes->GET('/restaurant_order_list', 'Restaurant::OrderList');
$routes->GET('/restaurant_menu', 'Restaurant::Menu');
// $routes->GET('/restaurant_menu_add', 'Restaurant::AddMenu');
$routes->GET('/api/restaurant/menu', 'Restaurant::MenuList');
$routes->POST('/restaurant/ToggleMenuStatus/(:num)', 'Restaurant::ToggleMenuStatus/$1');
$routes->match(['GET', 'POST'], '/restaurant_menu_add', 'Restaurant::addMenu');
$routes->POST('/restaurant_menu_update', 'Restaurant::updateMenu');
$routes->delete('/restaurant_menu_delete/(:num)', 'Restaurant::delete/$1');
$routes->POST('/restaurant/toggle_store', 'Restaurant::toggleStore');
$routes->POST('/restaurant/order/accept', 'Restaurant::OrderAccept');
$routes->POST('/restaurant/order/ready', 'Restaurant::OrderReady');
$routes->POST('/restaurant/order/check-pin', 'Restaurant::checkPin');
$routes->POST('/restaurant/toggle_auto_accept', 'Restaurant::toggleAutoAccept');



$routes->GET('/driver/food_order', 'OrderFoodController::index');
$routes->POST('/driver/food_order/action', 'OrderFoodController::action');
$routes->POST('/driver/toggle_driver_ride', 'Driver::ToggleRide');
$routes->POST('/driver/toggle_driver_food', 'Driver::ToggleFood');
$routes->POST('/driver/toggle_auto_bid', 'Driver::ToggleAutoBid');



$routes->GET('/api/restaurant/(:num)/menus', 'Menu::GETMenus/$1'); // data JSON



$routes->POST('api/orders', 'OrderController::create');


// halaman menu



$routes->POST('/GET-user', 'Home::GETUserData');
$routes->GET('/driver_order', 'Driver::Order');
$routes->GET('/token', 'Auth::CekToken');


$routes->group(
      '',
      ['filter' => 'auth'],
      function ($routes) {}
);



// $routes->GET('/', 'Home::index');
// $routes->GET('/GET-user', 'Home::GETUserData');
// $routes->GET('/login', 'Auth::login');
// $routes->GET('/driver', 'Driver::Index');
// $routes->GET('/driver_order', 'Driver::Order');
// $routes->POST('/logout', 'Auth::Logout');
// $routes->GET('/token', 'Auth::CekToken');
// $routes->GET('/auth/otp', 'Auth::otp');
// $routes->GET('/register', 'Home::register');
// $routes->POST('/login', 'Auth::loginPOST');
// $routes->POST('/auth/verifyOtp', 'Auth::verifyOtp');
// $routes->POST('/auth/otp/resend', 'OtpController::resendOtp');
// $routes->POST('/auth/otp/send', 'OtpController::sendOtp');
// $routes->POST('/setRole', 'Dashboard::setRole');
// $routes->GET('/role', 'Dashboard::Role');
// $routes->POST('/auth/registerPOST', 'Auth::registerPOST');
// $routes->GET('/customer', 'Customer::menu');
// $routes->GET('/alfaride', 'Customer::alfaride');
// $routes->GET('/alfafood', 'Customer::alfafood');
// $routes->GET('/order', 'OrderController::index');
// $routes->GET('/profile', 'ProfileController::index');
